/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.templates;

import freemarker.template.Configuration;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.jooreports.opendocument.OpenDocumentArchive;
import net.sf.jooreports.opendocument.OpenDocumentIO;
import net.sf.jooreports.templates.DocumentTemplate;
import net.sf.jooreports.templates.DocumentTemplateException;
import net.sf.jooreports.templates.TemplateAndModelMerger;
import net.sf.jooreports.templates.TemplatePreProcessor;

public abstract class AbstractDocumentTemplate
implements DocumentTemplate {
    private static final Configuration DEFAULT_FREEMARKER_CONFIGURATION = new Configuration();
    private static final DocumentTemplate.ContentWrapper DEFAULT_CONTENT_WRAPPER = new DocumentTemplate.ContentWrapper(){

        public String wrapContent(String content) {
            return "[#ftl]\n[#escape any as any?xml?replace(\"\\n\",\"<text:line-break />\")]\n" + content + "[/#escape]";
        }
    };
    private final Configuration freemarkerConfiguration;
    private DocumentTemplate.ContentWrapper contentWrapper = DEFAULT_CONTENT_WRAPPER;
    private String[] xmlEntries = new String[]{"content.xml", "styles.xml"};
    private OpenDocumentArchive preProcessedTemplate;
    private Map openDocumentSettings = new HashMap();
    private Map configurations = new HashMap();

    public AbstractDocumentTemplate() {
        this(DEFAULT_FREEMARKER_CONFIGURATION);
    }

    public AbstractDocumentTemplate(Configuration freemarkerConfiguration) {
        this.freemarkerConfiguration = freemarkerConfiguration;
    }

    public void setXmlEntries(String[] xmlEntries) {
        this.xmlEntries = xmlEntries;
        Arrays.sort(this.xmlEntries);
    }

    public void setContentWrapper(DocumentTemplate.ContentWrapper contentWrapper) {
        this.contentWrapper = contentWrapper;
    }

    protected abstract OpenDocumentArchive getOpenDocumentArchive();

    public void setOpenDocumentSettings(Map openDocumentSettings) {
        this.openDocumentSettings = openDocumentSettings;
    }

    public void createDocument(Object model, OutputStream output) throws IOException, DocumentTemplateException {
        if (this.preProcessedTemplate == null) {
            this.preProcess();
        }
        OpenDocumentArchive outputArchive = this.preProcessedTemplate.createCopy();
        TemplateAndModelMerger templateAndModelMerger = new TemplateAndModelMerger(this.freemarkerConfiguration, this.xmlEntries, this.openDocumentSettings, this.configurations);
        templateAndModelMerger.process(outputArchive, model);
        OpenDocumentIO.writeZip(outputArchive, output);
    }

    private void preProcess() throws IOException, DocumentTemplateException {
        this.preProcessedTemplate = this.getOpenDocumentArchive();
        TemplatePreProcessor templatePreProcessor = new TemplatePreProcessor(this.xmlEntries, this.contentWrapper, this.configurations);
        templatePreProcessor.process(this.preProcessedTemplate);
    }

    public Map getConfigurations() {
        return this.configurations;
    }
}

