/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.Response;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import java.io.IOException;

final class ResponseOperation
extends Operation
implements IdentifiedDataSerializable {
    private Object result;
    private boolean exception = false;
    private int backupCount;

    public ResponseOperation() {
    }

    ResponseOperation(Object result) {
        if (result instanceof Response) {
            Response response = (Response)result;
            this.result = response.response;
            this.backupCount = response.backupCount;
        } else {
            this.result = result;
        }
        this.exception = result instanceof Throwable;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        if (this.exception) {
            this.result = nodeEngine.toObject(this.result);
        }
        nodeEngine.operationService.notifyRemoteCall(this.getCallId(), this.getResponse());
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return this.exception ? this.result : new Response(this.result, this.getCallId(), this.backupCount);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        boolean isData = this.result instanceof Data;
        out.writeBoolean(isData);
        if (isData) {
            ((Data)this.result).writeData(out);
        } else {
            out.writeObject(this.result);
        }
        out.writeBoolean(this.exception);
        out.writeInt(this.backupCount);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        boolean isData = in.readBoolean();
        if (isData) {
            Data data = new Data();
            data.readData(in);
            this.result = data;
        } else {
            this.result = in.readObject();
        }
        this.exception = in.readBoolean();
        this.backupCount = in.readInt();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResponseOperation{");
        sb.append("result=").append(this.result);
        sb.append(", exception=").append(this.exception);
        sb.append(", backupCount=").append(this.backupCount);
        sb.append('}');
        return sb.toString();
    }
}

