/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.DynamicByteBuffer;
import com.hazelcast.nio.UTFUtil;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.SerializationContextAware;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class ByteBufferObjectDataOutput
extends OutputStream
implements BufferObjectDataOutput,
SerializationContextAware {
    private final DynamicByteBuffer buffer;
    private final SerializationService service;

    ByteBufferObjectDataOutput(int size, SerializationService service, ByteOrder order) {
        this.buffer = new DynamicByteBuffer(size, false);
        this.service = service;
        this.buffer.order(order);
    }

    ByteBufferObjectDataOutput(ByteBuffer buffer, SerializationService service, ByteOrder order) {
        this.buffer = new DynamicByteBuffer(buffer);
        buffer.order(order);
        this.service = service;
    }

    @Override
    public void write(int b) {
        this.buffer.put((byte)b);
    }

    @Override
    public void write(int position, int b) {
        this.buffer.put(position, (byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        this.buffer.put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeBoolean(int position, boolean v) throws IOException {
        this.write(position, v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeZeroBytes(int count) {
        for (int k = 0; k < count; ++k) {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int position, int v) throws IOException {
        this.write(position, v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.buffer.put((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.buffer.putChar((char)v);
    }

    @Override
    public void writeChar(int position, int v) throws IOException {
        this.buffer.putChar(position, (char)v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.buffer.putDouble(v);
    }

    @Override
    public void writeDouble(int position, double v) throws IOException {
        this.buffer.putDouble(position, v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.buffer.putFloat(v);
    }

    @Override
    public void writeFloat(int position, float v) throws IOException {
        this.buffer.putFloat(position, v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.buffer.putInt(v);
    }

    @Override
    public void writeInt(int position, int v) throws IOException {
        this.buffer.putInt(position, v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.buffer.putLong(v);
    }

    @Override
    public void writeLong(int position, long v) throws IOException {
        this.buffer.putLong(position, v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.buffer.putShort((short)v);
    }

    @Override
    public void writeShort(int position, int v) throws IOException {
        this.buffer.putShort(position, (short)v);
    }

    @Override
    public void writeCharArray(char[] chars) throws IOException {
        int len = chars != null ? chars.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (char c : chars) {
                this.writeChar(c);
            }
        }
    }

    @Override
    public void writeIntArray(int[] ints) throws IOException {
        int len = ints != null ? ints.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (int i : ints) {
                this.writeInt(i);
            }
        }
    }

    @Override
    public void writeLongArray(long[] longs) throws IOException {
        int len = longs != null ? longs.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (long l : longs) {
                this.writeLong(l);
            }
        }
    }

    @Override
    public void writeDoubleArray(double[] doubles) throws IOException {
        int len = doubles != null ? doubles.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (double d : doubles) {
                this.writeDouble(d);
            }
        }
    }

    @Override
    public void writeFloatArray(float[] floats) throws IOException {
        int len = floats != null ? floats.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (float f : floats) {
                this.writeFloat(f);
            }
        }
    }

    @Override
    public void writeShortArray(short[] shorts) throws IOException {
        int len = shorts != null ? shorts.length : 0;
        this.writeInt(len);
        if (len > 0) {
            for (short s : shorts) {
                this.writeShort(s);
            }
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        UTFUtil.writeUTF(this, str);
    }

    @Override
    public void writeObject(Object object) throws IOException {
        this.service.writeObject(this, object);
    }

    @Override
    public final int position() {
        return this.buffer.position();
    }

    @Override
    public void position(int newPos) {
        this.buffer.position(newPos);
    }

    public int available() {
        return this.buffer != null ? this.buffer.remaining() : 0;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer.array();
    }

    @Override
    public byte[] toByteArray() {
        if (this.buffer == null) {
            return new byte[0];
        }
        DynamicByteBuffer duplicate = this.buffer.duplicate();
        duplicate.flip();
        byte[] newBuffer = new byte[duplicate.limit()];
        duplicate.get(newBuffer);
        return newBuffer;
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    @Override
    public SerializationContext getSerializationContext() {
        return this.service.getSerializationContext();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.buffer.order();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBufferObjectDataOutput{");
        sb.append("buffer=").append(this.buffer);
        sb.append('}');
        return sb.toString();
    }
}

