/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public final class IntrospectionBasedDynamicMBean
implements DynamicMBean {
    private static final Logger LOG = Logger.getLogger(IntrospectionBasedDynamicMBean.class.getName());
    private Object obj;
    private final Map<String, Info> properties = new HashMap<String, Info>();

    public IntrospectionBasedDynamicMBean(Object obj) {
        this.obj = obj;
    }

    public Object getAttribute(String attribute) {
        String methodName = "get" + attribute;
        try {
            Method method = this.getMethod(this.obj.getClass(), methodName, new Class[0]);
            if (method == null) {
                methodName = "is" + attribute;
                method = this.getMethod(this.obj.getClass(), methodName, new Class[0]);
            }
            method.setAccessible(true);
            return method.invoke(this.obj, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured (InvocationTargetException) by accessing attribute " + attribute + ": " + ite.toString());
            }
            return null;
        }
        catch (IllegalAccessException iae) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured (IllegalAccessException) by accessing attribute " + attribute + ": " + iae.toString());
            }
            return null;
        }
    }

    private Method getMethod(Class clazz, String methodname, Class[] params) {
        while (true) {
            try {
                Method method = clazz.getDeclaredMethod(methodname, params);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException ignore) {
                for (Class<?> interf : clazz.getInterfaces()) {
                    this.getMethod(interf, methodname, params);
                }
                if ((clazz = clazz.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            list.add(new Attribute(attribute, this.getAttribute(attribute)));
        }
        return list;
    }

    public void setAttribute(Attribute attribute) {
        block4: {
            String methodName = "set" + attribute.getName();
            Info info = this.getInfo(attribute.getName());
            try {
                Method method = this.getMethod(this.obj.getClass(), methodName, new Class[]{info.propertyType});
                method.setAccessible(true);
                method.invoke(this.obj, attribute.getValue());
            }
            catch (InvocationTargetException ite) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured (InvocationTargetException) by setting attribute " + ite.toString());
                }
            }
            catch (IllegalAccessException iae) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine("error occured (IllegalAccessException) by setting attribute " + iae.toString());
            }
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        Attribute[] attrs;
        AttributeList result = new AttributeList();
        for (Attribute attr : attrs = attributes.toArray(new Attribute[attributes.size()])) {
            this.setAttribute(attr);
            result.add(new Attribute(attr.getName(), attr.getValue()));
        }
        return result;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    public synchronized MBeanInfo getMBeanInfo() {
        this.analyze(this.obj);
        String[] attributes = this.properties.keySet().toArray(new String[this.properties.size()]);
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attributes.length];
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = this.properties.get(attributes[i]).asbMBeanAttributeInfo();
        }
        return new MBeanInfo(this.obj.getClass().getName(), "", attrs, null, null, null);
    }

    private void analyze(Object obj) {
        Class<?> clazz = obj.getClass();
        do {
            this.analyzeType(clazz);
            for (Class<?> interf : clazz.getInterfaces()) {
                this.analyzeType(interf);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
    }

    private void analyzeType(Class clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            Info info;
            Class<?> propertyType;
            String name = method.getName();
            if (Modifier.isPrivate(method.getModifiers())) continue;
            if (name.length() > 3 && name.startsWith("get") && method.getParameterTypes().length == 0 && this.isAcceptedPropertyType(propertyType = method.getReturnType())) {
                info = this.getInfo(name.substring(3, name.length()));
                info.isReadable = true;
                info.propertyType = propertyType;
            }
            if (name.length() > 2 && name.startsWith("is") && method.getParameterTypes().length == 0 && this.isAcceptedPropertyType(propertyType = method.getReturnType())) {
                info = this.getInfo(name.substring(2, name.length()));
                info.isReadable = true;
                info.propertyType = propertyType;
            }
            if (name.length() <= 3 || !name.startsWith("set") || method.getParameterTypes().length != 1 || !this.isAcceptedPropertyType(propertyType = method.getParameterTypes()[0])) continue;
            info = this.getInfo(name.substring(3, name.length()));
            info.isWriteable = true;
            info.propertyType = propertyType;
        }
    }

    private Info getInfo(String name) {
        Info info = this.properties.get(name);
        if (info == null) {
            info = new Info();
            info.propertyName = name;
            info.propertyDescription = "Property " + info.propertyName;
            this.properties.put(name, info);
        }
        return info;
    }

    private boolean isAcceptedPropertyType(Class clazz) {
        if (clazz.isAssignableFrom(List.class)) {
            return true;
        }
        String name = clazz.getName();
        return name.equals("int") || name.equals("java.lang.Integer") || name.equals("long") || name.equals("java.lang.Long") || name.equals("double") || name.equals("java.lang.Double") || name.equals("boolean") || name.equals("java.lang.Boolean") || name.equals("float") || name.equals("java.lang.String") || name.equals("java.util.Date") || name.equals("java.lang.Float");
    }

    private static class Info {
        String propertyName = null;
        Class propertyType = null;
        String propertyDescription = null;
        boolean isReadable = false;
        boolean isWriteable = false;
        boolean isIs = false;

        private Info() {
        }

        MBeanAttributeInfo asbMBeanAttributeInfo() {
            return new MBeanAttributeInfo(this.propertyName, this.propertyType.getName(), this.propertyDescription, this.isReadable, this.isWriteable, this.isIs);
        }
    }
}

