/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.List;

public class RedirectRequiredException
extends ServiceException {
    private static final String LOCATION = "Location";

    public RedirectRequiredException(int sc, String location) {
        super("Redirect Required");
        this.setHttpErrorCodeOverride(sc);
        this.getHttpHeaders().put(LOCATION, Collections.singletonList(location));
    }

    public RedirectRequiredException(HttpURLConnection httpConn) throws IOException {
        super(httpConn);
        this.setHttpErrorCodeOverride(httpConn.getResponseCode());
    }

    public String getRedirectLocation() {
        List<String> location = this.getHttpHeader(LOCATION);
        if (location != null && location.size() > 0) {
            return location.get(0);
        }
        return null;
    }
}

