/*
 * Decompiled with CFR 0.152.
 */
package de.kippdata.solrext.analyzer;

import de.kippdata.solrext.tokenfilter.DomainSkipFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;

public class DomainSkipFilterFactory
extends BaseTokenFilterFactory {
    private List<String> domainList = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(DomainSkipFilterFactory.class);

    public void init(Map<String, String> params) {
        super.init(params);
        if (this.args.containsKey("domains")) {
            String[] domainArray;
            for (String s : domainArray = ((String)this.args.get("domains")).split("\\s+")) {
                this.domainList.add("." + s);
            }
        }
        log.info((Object)("[init]: Initializing: Domains are '" + (String)this.args.get("domains") + "'"));
    }

    public TokenStream create(TokenStream input) {
        return new DomainSkipFilter(input, this.domainList);
    }
}

