/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import javax.servlet.ServletException;
import org.javasimon.Simon;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.action.AbstractJsonAction;
import org.javasimon.console.action.DetailPlugin;
import org.javasimon.console.json.ArrayJS;
import org.javasimon.console.json.ObjectJS;

public class DetailJsonAction
extends AbstractJsonAction {
    public static final String PATH = "/data/detail.json";
    private String name;

    public DetailJsonAction(ActionContext context) {
        super(context);
    }

    public void readParameters() {
        super.readParameters();
        this.name = this.getContext().getParameterAsString("name", null);
    }

    public void execute() throws ServletException, IOException, ActionException {
        if (this.name == null) {
            throw new ActionException("Null name");
        }
        Simon simon = this.getContext().getManager().getSimon(this.name);
        if (simon == null) {
            throw new ActionException("Simon \"" + this.name + "\" not found");
        }
        this.getContext().setContentType("application/json");
        ObjectJS simonJS = this.createObjectJS(simon);
        ArrayJS pluginsJS = new ArrayJS();
        for (DetailPlugin plugin : this.getContext().getPluginManager().getPluginsByType(DetailPlugin.class)) {
            if (!plugin.supports(simon)) continue;
            ObjectJS pluginJS = plugin.toJson(this.jsonStringifierFactory);
            ObjectJS pluginDataJS = plugin.executeJson(this.getContext(), this.jsonStringifierFactory, simon);
            if (pluginDataJS != null) {
                pluginJS.setAttribute("data", pluginDataJS);
            }
            pluginsJS.addElement(pluginJS);
        }
        simonJS.setAttribute("plugins", pluginsJS);
        simonJS.write(this.getContext().getWriter());
    }
}

