/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.testapp;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.h2.tools.RunScript;
import org.javasimon.SimonManager;
import org.javasimon.jdbc4.jmx.JdbcMXBeanImpl;
import org.javasimon.jmx.SimonManagerMXBeanImpl;
import org.javasimon.testapp.DeleteAction;
import org.javasimon.testapp.InsertAction;
import org.javasimon.testapp.InsertBatchAction;
import org.javasimon.testapp.RandomNumberDataProvider;
import org.javasimon.testapp.UniformRandomTimer;
import org.javasimon.testapp.UpdateAction;
import org.javasimon.testapp.WeightController;
import org.javasimon.testapp.mm.AppMXBean;
import org.javasimon.testapp.test.Runner;

public class Main {
    private Runner runner;
    private Connection connection;

    private void setupDatabase() throws Exception {
        RunScript.execute((String)"jdbc:h2:file:testappdb", (String)"sa", (String)"sa", (String)"examples/testapp.db.sql", null, (boolean)false);
        this.connection = DriverManager.getConnection("jdbc:simon:h2:file:testappdb;simon_prefix=org.javasimon.testapp.jdbc", "sa", "sa");
    }

    private void closeDatabase() throws Exception {
        this.connection.close();
    }

    private void setupRunner() {
        WeightController controller = new WeightController();
        controller.addAction(new InsertAction(new RandomNumberDataProvider(700), this.connection), 34);
        controller.addAction(new InsertBatchAction(this.connection), 12);
        controller.addAction(new UpdateAction(new RandomNumberDataProvider(400), this.connection), 28);
        controller.addAction(new DeleteAction(new RandomNumberDataProvider(600), this.connection), 26);
        UniformRandomTimer timer = new UniformRandomTimer(7100L, 900L);
        this.runner = new Runner(controller, timer);
    }

    private void setupJmx() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            AppMXBeanImpl app = new AppMXBeanImpl();
            mbs.registerMBean(app, new ObjectName("org.javasimon.testapp:type=App"));
            System.out.println("AppMXBean registerd");
            SimonManagerMXBeanImpl simonManagerMXBean = new SimonManagerMXBeanImpl(SimonManager.manager());
            mbs.registerMBean(simonManagerMXBean, new ObjectName("org.javasimon.testapp:type=Simon"));
            System.out.println("SimonManagerMXBean registerd");
            JdbcMXBeanImpl jdbc = new JdbcMXBeanImpl(SimonManager.manager(), "org.javasimon.testapp.jdbc");
            mbs.registerMBean(jdbc, new ObjectName("org.javasimon.testapp:type=Jdbc"));
            System.out.println("JdbcMXBean registerd");
        }
        catch (JMException e) {
            System.out.println("JMX beans registration failed!\n" + e);
        }
    }

    private void run() {
        this.runner.run();
    }

    public static void main(String[] args) throws Exception {
        Main m = new Main();
        m.setupDatabase();
        m.setupRunner();
        m.setupJmx();
        m.run();
        m.closeDatabase();
    }

    public class AppMXBeanImpl
    implements AppMXBean {
        public void shutdown() {
            if (Main.this.runner != null) {
                Main.this.runner.stop();
            }
        }
    }
}

