/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.record.CachedDataRecord;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class QueryOperation
extends AbstractMapOperation {
    Predicate predicate;
    QueryResult result;

    public QueryOperation(String mapName, Predicate predicate) {
        super(mapName);
        this.predicate = predicate;
    }

    public QueryOperation() {
    }

    @Override
    public void run() throws Exception {
        List<Integer> initialPartitions = this.mapService.getOwnedPartitions();
        IndexService indexService = this.mapService.getMapContainer(this.name).getIndexService();
        Set<QueryableEntry> entries = null;
        if (!this.getNodeEngine().getPartitionService().hasOnGoingMigration()) {
            entries = indexService.query(this.predicate);
        }
        this.result = new QueryResult();
        if (entries != null) {
            for (QueryableEntry entry : entries) {
                this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
            }
        } else {
            this.runParallel(initialPartitions);
        }
        List<Integer> finalPartitions = this.mapService.getOwnedPartitions();
        if (((Object)initialPartitions).equals(finalPartitions)) {
            this.result.setPartitionIds(finalPartitions);
        }
        if (this.mapContainer.getMapConfig().isStatisticsEnabled()) {
            ((MapService)this.getService()).getLocalMapStatsImpl(this.name).incrementOtherOperations();
        }
    }

    private void runParallel(List<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        final SerializationService ss = this.getNodeEngine().getSerializationService();
        ManagedExecutorService executor = this.getNodeEngine().getExecutionService().getExecutor("hz:query");
        ArrayList<Future<ConcurrentMap<Object, QueryableEntry>>> lsFutures = new ArrayList<Future<ConcurrentMap<Object, QueryableEntry>>>(initialPartitions.size());
        for (final Integer n : initialPartitions) {
            Future<ConcurrentMap<Object, QueryableEntry>> f = executor.submit(new Callable<ConcurrentMap<Object, QueryableEntry>>(){

                @Override
                public ConcurrentMap<Object, QueryableEntry> call() {
                    PartitionContainer container = QueryOperation.this.mapService.getPartitionContainer(n);
                    RecordStore recordStore = container.getRecordStore(QueryOperation.this.name);
                    ConcurrentHashMap<Data, QueryEntry> partitionResult = null;
                    for (Record record : recordStore.getReadonlyRecordMap().values()) {
                        QueryEntry queryEntry;
                        Object value;
                        Data key = record.getKey();
                        if (record instanceof CachedDataRecord) {
                            CachedDataRecord cachedDataRecord = (CachedDataRecord)record;
                            value = cachedDataRecord.getCachedValue();
                            if (value == null) {
                                value = ss.toObject(cachedDataRecord.getValue());
                                cachedDataRecord.setCachedValue(value);
                            }
                        } else {
                            value = record.getValue();
                            if (value instanceof Data) {
                                value = ss.toObject((Data)value);
                            }
                        }
                        if (value == null || !QueryOperation.this.predicate.apply(queryEntry = new QueryEntry(ss, key, key, value))) continue;
                        if (partitionResult == null) {
                            partitionResult = new ConcurrentHashMap<Data, QueryEntry>();
                        }
                        partitionResult.put(queryEntry.getIndexKey(), queryEntry);
                    }
                    return partitionResult;
                }
            });
            lsFutures.add(f);
        }
        for (Future future : lsFutures) {
            ConcurrentMap r = (ConcurrentMap)future.get();
            if (r == null) continue;
            for (QueryableEntry entry : r.values()) {
                this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
            }
        }
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        if (throwable instanceof MemberLeftException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        if (throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.name);
        out.writeObject(this.predicate);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readUTF();
        this.predicate = (Predicate)in.readObject();
    }
}

