/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.collection.CollectionPortableHook;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.SetPermission;
import java.io.IOException;
import java.security.Permission;

public abstract class CollectionRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    protected String serviceName;
    protected String name;

    public CollectionRequest() {
    }

    public CollectionRequest(String name) {
        this.name = name;
    }

    @Override
    protected int getPartition() {
        return this.getClientEngine().getPartitionService().getPartitionId(StringPartitioningStrategy.getPartitionKey(this.name));
    }

    @Override
    protected int getReplicaIndex() {
        return 0;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public int getFactoryId() {
        return CollectionPortableHook.F_ID;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("s", this.serviceName);
        writer.writeUTF("n", this.name);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.serviceName = reader.readUTF("s");
        this.name = reader.readUTF("n");
    }

    @Override
    public final Permission getRequiredPermission() {
        String action = this.getRequiredAction();
        if ("hz:impl:listService".equals(this.serviceName)) {
            return new ListPermission(this.name, action);
        }
        if ("hz:impl:setService".equals(this.serviceName)) {
            return new SetPermission(this.name, action);
        }
        throw new IllegalArgumentException("No service matched!!!");
    }

    public abstract String getRequiredAction();
}

