/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class PartitionRuntimeState
implements DataSerializable {
    protected ArrayList<MemberInfo> members = new ArrayList(100);
    protected Collection<ShortPartitionInfo> partitionInfos = new LinkedList<ShortPartitionInfo>();
    private long masterTime = Clock.currentTimeMillis();
    private int version;
    private Connection connection;

    public PartitionRuntimeState() {
    }

    public long getMasterTime() {
        return this.masterTime;
    }

    public PartitionRuntimeState(Collection<MemberInfo> memberInfos, PartitionInfo[] partitions, long masterTime, int version) {
        this.masterTime = masterTime;
        this.version = version;
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(memberInfos.size());
        int memberIndex = 0;
        for (MemberInfo memberInfo : memberInfos) {
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            ++memberIndex;
        }
        this.setPartitions(partitions, addressIndexes);
    }

    public ArrayList<MemberInfo> getMembers() {
        return this.members;
    }

    protected void addMemberInfo(MemberInfo memberInfo, Map<Address, Integer> addressIndexes, int memberIndex) {
        this.members.add(memberIndex, memberInfo);
        addressIndexes.put(memberInfo.getAddress(), memberIndex);
    }

    protected void setPartitions(PartitionInfo[] partitions, Map<Address, Integer> addressIndexes) {
        PartitionInfo[] partitionInfoArray = partitions;
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            PartitionInfo partition = partitionInfoArray[n2];
            ShortPartitionInfo spi = new ShortPartitionInfo(partition.getPartitionId());
            int i = 0;
            while (i < 7) {
                Address address = partition.getReplicaAddress(i);
                if (address == null) {
                    spi.addressIndexes[i] = -1;
                } else {
                    Integer knownIndex = addressIndexes.get(address);
                    spi.addressIndexes[i] = knownIndex == null ? -1 : knownIndex;
                }
                ++i;
            }
            this.partitionInfos.add(spi);
            ++n2;
        }
    }

    public PartitionInfo[] getPartitions() {
        int size = this.partitionInfos.size();
        PartitionInfo[] partitions = new PartitionInfo[size];
        for (ShortPartitionInfo spi : this.partitionInfos) {
            PartitionInfo partition = new PartitionInfo(spi.partitionId, null);
            int[] addressIndexes = spi.addressIndexes;
            int c = 0;
            while (c < addressIndexes.length) {
                int index = addressIndexes[c];
                if (index != -1) {
                    partition.setReplicaAddress(c, this.members.get(index).getAddress());
                }
                ++c;
            }
            partitions[spi.partitionId] = partition;
        }
        return partitions;
    }

    public Connection getConnection() {
        return this.connection;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.masterTime = in.readLong();
        this.version = in.readInt();
        int size = in.readInt();
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(size);
        int memberIndex = 0;
        while (size-- > 0) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.readData(in);
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            ++memberIndex;
        }
        int partitionCount = in.readInt();
        int i = 0;
        while (i < partitionCount) {
            ShortPartitionInfo spi = new ShortPartitionInfo();
            spi.readData(in);
            this.partitionInfos.add(spi);
            ++i;
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.masterTime);
        out.writeInt(this.version);
        int memberSize = this.members.size();
        out.writeInt(memberSize);
        int i = 0;
        while (i < memberSize) {
            MemberInfo memberInfo = this.members.get(i);
            memberInfo.writeData(out);
            ++i;
        }
        out.writeInt(this.partitionInfos.size());
        for (ShortPartitionInfo spi : this.partitionInfos) {
            spi.writeData(out);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionRuntimeState [" + this.version + "]{\n");
        for (MemberInfo address : this.members) {
            sb.append(address).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    public int getVersion() {
        return this.version;
    }

    class ShortPartitionInfo
    implements DataSerializable {
        int partitionId;
        int[] addressIndexes = new int[7];

        ShortPartitionInfo(int partitionId) {
            this.partitionId = partitionId;
        }

        ShortPartitionInfo() {
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeInt(this.partitionId);
            int i = 0;
            while (i < 7) {
                out.writeInt(this.addressIndexes[i]);
                ++i;
            }
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.partitionId = in.readInt();
            int i = 0;
            while (i < 7) {
                this.addressIndexes[i] = in.readInt();
                ++i;
            }
        }
    }
}

