/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.IdGeneratorProxy;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.nio.DataSerializable;
import java.util.concurrent.atomic.AtomicLong;

public class IdGeneratorProxyImpl
extends FactoryAwareNamedProxy
implements IdGeneratorProxy,
DataSerializable {
    private transient IdGeneratorProxy base = null;

    public IdGeneratorProxyImpl() {
    }

    public IdGeneratorProxyImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.base = new IdGeneratorBase();
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (IdGeneratorProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    @Override
    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String toString() {
        return "IdGenerator [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdGeneratorProxyImpl that = (IdGeneratorProxyImpl)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    @Override
    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    @Override
    public String getName() {
        this.ensure();
        return this.base.getName();
    }

    @Override
    public long newId() {
        this.ensure();
        return this.base.newId();
    }

    private class IdGeneratorBase
    implements IdGeneratorProxy {
        private static final long MILLION = 1000000L;
        final AtomicLong million = new AtomicLong(-1L);
        final AtomicLong currentId = new AtomicLong(2000000L);

        private IdGeneratorBase() {
        }

        @Override
        public String getName() {
            return IdGeneratorProxyImpl.this.name.substring("i:".length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long newId() {
            long idAddition = this.currentId.incrementAndGet();
            if (idAddition >= 1000000L) {
                IdGeneratorBase idGeneratorBase = this;
                synchronized (idGeneratorBase) {
                    idAddition = this.currentId.get();
                    if (idAddition >= 1000000L) {
                        Long idMillion = this.getNewMillion();
                        long newMillion = idMillion * 1000000L;
                        this.million.set(newMillion);
                        this.currentId.set(0L);
                    }
                    return this.newId();
                }
            }
            long millionNow = this.million.get();
            return millionNow + idAddition;
        }

        private Long getNewMillion() {
            return IdGeneratorProxyImpl.this.factory.getAtomicNumber("__hz_idGen_" + this.getName()).incrementAndGet() - 1L;
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.ID_GENERATOR;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            this.currentId.set(2000000L);
            IdGeneratorBase idGeneratorBase = this;
            synchronized (idGeneratorBase) {
                IdGeneratorProxyImpl.this.factory.destroyInstanceClusterWide(IdGeneratorProxyImpl.this.name, null);
                IdGeneratorProxyImpl.this.factory.getAtomicNumber("__hz_idGen_" + this.getName()).destroy();
                this.currentId.set(2000000L);
                this.million.set(-1L);
            }
        }

        @Override
        public Object getId() {
            return IdGeneratorProxyImpl.this.name;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

