/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.LockServiceImpl;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.concurrent.lock.LockStoreInfo;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class LockStoreContainer {
    private final LockServiceImpl lockService;
    private final int partitionId;
    private final ConcurrentMap<ObjectNamespace, LockStoreImpl> lockStores = new ConcurrentHashMap<ObjectNamespace, LockStoreImpl>();
    private final ConstructorFunction<ObjectNamespace, LockStoreImpl> lockStoreConstructor = new ConstructorFunction<ObjectNamespace, LockStoreImpl>(){

        @Override
        public LockStoreImpl createNew(ObjectNamespace namespace) {
            LockStoreInfo info;
            ConstructorFunction ctor = (ConstructorFunction)((LockStoreContainer)LockStoreContainer.this).lockService.constructors.get(namespace.getServiceName());
            if (ctor != null && (info = (LockStoreInfo)ctor.createNew(namespace)) != null) {
                return new LockStoreImpl(LockStoreContainer.this.lockService, namespace, info.getBackupCount(), info.getAsyncBackupCount());
            }
            throw new IllegalArgumentException("No LockStore constructor is registered!");
        }
    };

    public LockStoreContainer(LockServiceImpl lockService, int partitionId) {
        this.lockService = lockService;
        this.partitionId = partitionId;
    }

    void clearLockStore(ObjectNamespace namespace) {
        LockStoreImpl lockStore = (LockStoreImpl)this.lockStores.get(namespace);
        if (lockStore != null) {
            lockStore.clear();
        }
    }

    LockStoreImpl getOrCreateLockStore(ObjectNamespace namespace) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.lockStores, namespace, this.lockStoreConstructor);
    }

    LockStoreImpl getLockStore(ObjectNamespace namespace) {
        return (LockStoreImpl)this.lockStores.get(namespace);
    }

    Collection<LockStoreImpl> getLockStores() {
        return Collections.unmodifiableCollection(this.lockStores.values());
    }

    void clear() {
        for (LockStoreImpl lockStore : this.lockStores.values()) {
            lockStore.clear();
        }
        this.lockStores.clear();
    }

    int getPartitionId() {
        return this.partitionId;
    }

    void put(LockStoreImpl ls) {
        ls.setLockService(this.lockService);
        this.lockStores.put(ls.getNamespace(), ls);
    }
}

