/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.xpath.xalan;

import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBaseIterators;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.NamespaceAware;
import org.jdom2.Parent;
import org.jdom2.contrib.xpath.xalan.NamespacePointer;
import org.jdom2.internal.ArrayCopy;
import org.jdom2.transform.JDOMSource;
import org.jdom2.util.NamespaceStack;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JDOM2DTM
extends DTMDefaultBaseIterators {
    private NamespaceAware[] i_nodes = new NamespaceAware[1024];
    private final String systemId;
    private final String publicID;

    private static final int getType(NamespaceAware nsa) {
        if (nsa instanceof Content) {
            switch (((Content)nsa).getCType()) {
                case CDATA: {
                    return 4;
                }
                case Comment: {
                    return 8;
                }
                case DocType: {
                    return 10;
                }
                case Element: {
                    return 1;
                }
                case EntityRef: {
                    return 5;
                }
                case ProcessingInstruction: {
                    return 7;
                }
                case Text: {
                    return 3;
                }
            }
        } else {
            if (nsa instanceof Document) {
                return 9;
            }
            if (nsa instanceof Attribute) {
                return 2;
            }
            if (nsa instanceof NamespacePointer) {
                return 13;
            }
        }
        throw new IllegalStateException("Unknonw node type " + nsa);
    }

    public JDOM2DTM(DTMManager mgr, JDOMSource source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        super(mgr, (Source)source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing);
        String pid = null;
        String sid = null;
        Document root = source.getDocument();
        NamespaceStack nstack = new NamespaceStack();
        if (root != null) {
            Document doc = root;
            this.setDocumentBaseURI(doc.getBaseURI());
            DocType dt = doc.getDocType();
            if (dt != null) {
                sid = dt.getSystemID();
                pid = dt.getPublicID();
            }
            if (sid == null) {
                sid = doc.getBaseURI();
            }
            this.addNodes(nstack, -1, Collections.singletonList(doc));
        } else {
            this.addNodes(nstack, -1, source.getNodes());
        }
        this.systemId = sid;
        this.publicID = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int addNode(NamespaceStack nstack, int parent, int prevsib, NamespaceAware nsa) {
        int nodeIndex;
        if ((nodeIndex = this.m_size++) >= this.i_nodes.length) {
            this.i_nodes = (NamespaceAware[])ArrayCopy.copyOf((Object[])this.i_nodes, (int)(nodeIndex + (nodeIndex >> 1) + 1));
        }
        this.i_nodes[nodeIndex] = nsa;
        if (this.m_dtmIdent.size() == nodeIndex >>> 16) {
            if (this.m_mgr == null) {
                this.error(XMLMessages.createXMLMessage((String)"ER_NO_DTMIDS_AVAIL", null));
            }
            DTMManagerDefault mgrD = (DTMManagerDefault)this.m_mgr;
            int id = mgrD.getFirstFreeDTMID();
            mgrD.addDTM((DTM)this, id, nodeIndex);
            this.m_dtmIdent.addElement(id << 16);
        }
        this.m_firstch.setElementAt(-2, nodeIndex);
        this.m_nextsib.setElementAt(-2, nodeIndex);
        this.m_prevsib.setElementAt(prevsib, nodeIndex);
        this.m_parent.setElementAt(parent, nodeIndex);
        if ((nsa instanceof Content || nsa instanceof Document) && -2 == this.m_firstch.elementAt(parent)) {
            this.m_firstch.setElementAt(nodeIndex, parent);
        }
        String localname = null;
        String nsuri = null;
        if (nsa instanceof Element) {
            localname = ((Element)nsa).getName();
            nsuri = ((Element)nsa).getNamespaceURI();
        } else if (nsa instanceof Attribute) {
            localname = ((Attribute)nsa).getName();
            nsuri = ((Attribute)nsa).getNamespaceURI();
        }
        ExpandedNameTable exnt = this.m_expandedNameTable;
        int ntype = JDOM2DTM.getType(nsa);
        int expandedNameID = localname == null ? exnt.getExpandedTypeID(ntype) : exnt.getExpandedTypeID(nsuri, localname, ntype);
        this.m_exptype.setElementAt(expandedNameID, nodeIndex);
        this.indexNode(expandedNameID, nodeIndex);
        if (!(nsa instanceof Parent)) return nodeIndex;
        Parent pn = (Parent)nsa;
        if (pn instanceof Element) {
            Element element = (Element)pn;
            nstack.push(element);
            try {
                int pns = -1;
                int nsid = -1;
                for (Namespace ns : nstack.addedForward()) {
                    nsid = this.addNode(nstack, nodeIndex, pns, new NamespacePointer(ns));
                    if (pns != -1) {
                        this.m_nextsib.setElementAt(nsid, pns);
                    }
                    pns = nsid;
                }
                if (nsid != -1) {
                    this.m_nextsib.setElementAt(-1, nsid);
                }
                if (element.hasAttributes()) {
                    int patt = -1;
                    int attid = -1;
                    for (Attribute att : element.getAttributes()) {
                        attid = this.addNode(nstack, nodeIndex, patt, (NamespaceAware)att);
                        if (patt != -1) {
                            this.m_nextsib.setElementAt(attid, patt);
                        }
                        patt = attid;
                    }
                    if (attid != -1) {
                        this.m_nextsib.setElementAt(-1, attid);
                    }
                }
                if (element.getContentSize() <= 0) return nodeIndex;
                this.addNodes(nstack, nodeIndex, element.getContent());
                return nodeIndex;
            }
            finally {
                nstack.pop();
            }
        } else {
            if (pn.getContentSize() <= 0) return nodeIndex;
            this.addNodes(nstack, nodeIndex, pn.getContent());
        }
        return nodeIndex;
    }

    private void addNodes(NamespaceStack nstack, int parentIndex, List<? extends NamespaceAware> list) {
        int cs = list.size();
        if (cs > 0) {
            int pvid = -1;
            int cid = -1;
            for (int i = 0; i < cs; ++i) {
                NamespaceAware c = list.get(i);
                cid = this.addNode(nstack, parentIndex, pvid, c);
                if (pvid == -1) {
                    this.m_firstch.setElementAt(cid, parentIndex);
                } else {
                    this.m_nextsib.setElementAt(cid, pvid);
                }
                pvid = cid;
            }
            if (cid != -1) {
                this.m_nextsib.setElementAt(-1, cid);
            }
        }
    }

    protected int getNextNodeIdentity(int identity) {
        if (++identity >= this.m_size) {
            identity = -1;
        }
        return identity;
    }

    protected boolean nextNode() {
        return false;
    }

    protected int getNumberOfNodes() {
        return this.m_size;
    }

    public int getAttributeNode(int nodeHandle, String namespaceURI, String name) {
        return 0;
    }

    public XMLString getStringValue(int nodeHandle) {
        return null;
    }

    public String getNodeName(int nodeHandle) {
        return null;
    }

    public String getLocalName(int nodeHandle) {
        return null;
    }

    public String getPrefix(int nodeHandle) {
        return null;
    }

    public String getNamespaceURI(int nodeHandle) {
        return null;
    }

    public String getNodeValue(int nodeHandle) {
        return null;
    }

    public String getDocumentTypeDeclarationSystemIdentifier() {
        return this.systemId;
    }

    public String getDocumentTypeDeclarationPublicIdentifier() {
        return this.publicID;
    }

    public int getElementById(String elementId) {
        return 0;
    }

    public String getUnparsedEntityURI(String name) {
        return null;
    }

    public boolean isAttributeSpecified(int attributeHandle) {
        return true;
    }

    public SourceLocator getSourceLocatorFor(int node) {
        return null;
    }

    public void setProperty(String property, Object value) {
    }

    public boolean needsTwoThreads() {
        return false;
    }

    public ContentHandler getContentHandler() {
        return null;
    }

    public LexicalHandler getLexicalHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public DeclHandler getDeclHandler() {
        return null;
    }

    public void dispatchCharactersEvents(int nodeHandle, ContentHandler ch, boolean normalize) throws SAXException {
    }

    public void dispatchToEvents(int nodeHandle, ContentHandler ch) throws SAXException {
    }
}

