/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReader
implements Closeable {
    private BufferedReader br;
    private boolean hasNext = true;
    private final char separator;
    private final char quotechar;
    private final char escape;
    private int skipLines;
    private boolean linesSkiped;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 64;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final int DEFAULT_SKIP_LINES = 0;

    public CSVReader(Reader reader) {
        this(reader, ',');
    }

    public CSVReader(Reader reader, char c) {
        this(reader, c, '\"', '\\');
    }

    public CSVReader(Reader reader, char c, char c2) {
        this(reader, c, c2, '\\', 0);
    }

    public CSVReader(Reader reader, char c, char c2, char c3) {
        this(reader, c, c2, c3, 0);
    }

    public CSVReader(Reader reader, char c, char c2, int n) {
        this(reader, c, c2, '\\', n);
    }

    public CSVReader(Reader reader, char c, char c2, char c3, int n) {
        this.br = new BufferedReader(reader);
        this.separator = c;
        this.quotechar = c2;
        this.escape = c3;
        this.skipLines = n;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] stringArray = this.readNext();
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public String[] readNext() throws IOException {
        String string = this.getNextLine();
        return this.hasNext ? this.parseLine(string) : null;
    }

    private String getNextLine() throws IOException {
        String string;
        if (!this.linesSkiped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.br.readLine();
            }
            this.linesSkiped = true;
        }
        if ((string = this.br.readLine()) == null) {
            this.hasNext = false;
        }
        return this.hasNext ? string : null;
    }

    private String[] parseLine(String string) throws IOException {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(64);
        boolean bl = false;
        do {
            if (bl) {
                stringBuilder.append("\n");
                string = this.getNextLine();
                if (string == null) break;
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == this.escape) {
                    if (!this.isEscapable(string, bl, i)) continue;
                    stringBuilder.append(string.charAt(i + 1));
                    ++i;
                    continue;
                }
                if (c == this.quotechar) {
                    if (this.isEscapedQuote(string, bl, i)) {
                        stringBuilder.append(string.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    boolean bl2 = bl = !bl;
                    if (i <= 2 || string.charAt(i - 1) == this.separator || string.length() <= i + 1 || string.charAt(i + 1) == this.separator) continue;
                    stringBuilder.append(c);
                    continue;
                }
                if (c == this.separator && !bl) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder(64);
                    continue;
                }
                stringBuilder.append(c);
            }
        } while (bl);
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[0]);
    }

    private boolean isEscapedQuote(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && string.charAt(n + 1) == this.quotechar;
    }

    private boolean isEscapable(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && (string.charAt(n + 1) == this.quotechar || string.charAt(n + 1) == this.escape);
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }
}

