/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.File;
import java.net.URLEncoder;
import net.sf.antcontrib.property.AbstractPropertySetterTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;

public class URLEncodeTask
extends AbstractPropertySetterTask {
    private String value;
    private Reference ref;

    public void setName(String string) {
        this.setProperty(string);
    }

    public void setValue(String string) {
        this.value = URLEncoder.encode(string);
    }

    public String getValue(Project project) {
        String string = this.value;
        if (this.ref != null) {
            string = this.ref.getReferencedObject(project).toString();
        }
        return string;
    }

    public void setLocation(File file) {
        this.setValue(file.getAbsolutePath());
    }

    public void setRefid(Reference reference) {
        this.ref = reference;
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    protected void validate() {
        super.validate();
        if (this.value == null && this.ref == null) {
            throw new BuildException("You must specify value, location or refid with the name attribute", this.getLocation());
        }
    }

    public void execute() {
        this.validate();
        String string = this.getValue(this.getProject());
        this.setPropertyValue(string);
    }
}

