/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class HintMediaHeaderBox
extends AbstractMediaHeaderBox {
    private int maxPduSize;
    private int avgPduSize;
    private long maxBitrate;
    private long avgBitrate;
    public static final String TYPE = "hmhd";

    public HintMediaHeaderBox() {
        super(TYPE);
    }

    public int getMaxPduSize() {
        return this.maxPduSize;
    }

    public int getAvgPduSize() {
        return this.avgPduSize;
    }

    public long getMaxBitrate() {
        return this.maxBitrate;
    }

    public long getAvgBitrate() {
        return this.avgBitrate;
    }

    protected long getContentSize() {
        return 16L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.maxPduSize = in.readUInt16();
        this.avgPduSize = in.readUInt16();
        this.maxBitrate = in.readUInt32();
        this.avgBitrate = in.readUInt32();
        in.readUInt32();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt16(this.maxPduSize);
        isos.writeUInt16(this.avgPduSize);
        isos.writeUInt32(this.maxBitrate);
        isos.writeUInt32(this.avgBitrate);
        isos.writeUInt32(0L);
    }

    public String toString() {
        return "HintMediaHeaderBox{maxPduSize=" + this.maxPduSize + ", avgPduSize=" + this.avgPduSize + ", maxBitrate=" + this.maxBitrate + ", avgBitrate=" + this.avgBitrate + '}';
    }
}

