/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.groupware.infostore.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.utils.Metadata;

/**
 * {@link DocumentMetadataValidation}
 */
public class DocumentMetadataValidation {

    private final Map<Metadata, String> errors;
    private final List<Metadata> errorFields;
    private OXException exception;
    private OXException fatalException;

    /**
     * Initializes a new {@link DocumentMetadataValidation}.
     */
    public DocumentMetadataValidation() {
        super();
        errors = new HashMap<Metadata, String>();
        errorFields = new ArrayList<Metadata>();
    }

    public boolean isValid() {
        return errors.isEmpty() && null == fatalException;
    }

    public boolean hasErrors(final Metadata field) {
        return errors.containsKey(field);
    }

    public String getError(final Metadata field) {
        return errors.get(field);
    }

    public void setError(final Metadata field, final String error) {
        errors.put(field, error);
        errorFields.add(field);
    }

    public List<Metadata> getInvalidFields() {
        return errorFields;
    }

    /**
     * Gets the fatal exception
     *
     * @return The fatal exception
     */
    public OXException getFatalException() {
        return fatalException;
    }

    /**
     * Sets the fatal exception
     *
     * @param fatalException The fatal exception to set
     */
    public void setFatalException(OXException fatalException) {
        this.fatalException = fatalException;
    }

    /**
     * Gets the exception
     *
     * @return The exception
     */
    public OXException getException() {
        return exception;
    }

    /**
     * Sets the exception
     *
     * @param exception The exception to set
     */
    public void setException(OXException exception) {
        this.exception = exception;
    }

}
