/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import org.javasimon.EnabledManager;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.Callback;
import org.javasimon.callback.CallbackSkeleton;
import org.javasimon.callback.CompositeFilterCallback;
import org.javasimon.callback.FilterRule;
import org.javasimon.utils.SimonUtils;

public final class CallbackFilteringExample {
    public static void main(String[] args) {
        EnabledManager manager = new EnabledManager();
        Stopwatch sw1 = manager.getStopwatch("org.javasimon.examples.stopwatch1");
        Stopwatch sw2 = manager.getStopwatch("other.stopwatch2");
        CallbackSkeleton stdoutCallback = new CallbackSkeleton(){

            public void onStopwatchStart(Split split) {
                System.out.println("Starting " + split.getStopwatch().getName());
            }

            public void onStopwatchStop(Split split, StopwatchSample sample) {
                System.out.println("Stopped " + split.getStopwatch().getName() + " (" + SimonUtils.presentNanoTime((long)split.runningFor()) + ")");
            }
        };
        manager.callback().addCallback((Callback)stdoutCallback);
        sw1.start().stop();
        sw2.start().stop();
        System.out.println();
        manager.callback().removeCallback((Callback)stdoutCallback);
        SimonManager.callback().removeAllCallbacks();
        CompositeFilterCallback filter = new CompositeFilterCallback();
        filter.addRule(FilterRule.Type.MUST_NOT, null, "other.*", new Callback.Event[0]);
        filter.addCallback((Callback)stdoutCallback);
        manager.callback().addCallback((Callback)filter);
        sw1.start().stop();
        sw2.start().stop();
    }
}

