/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.javasimon.SimonManager;
import org.javasimon.Stopwatch;
import org.javasimon.utils.SimonUtils;

public class MultithreadedTester
extends Thread {
    private static final String NAME = SimonUtils.generateName();
    private final int threads;
    private final int loop;
    private ExecutorService executorService;
    private final Runnable task = new TestTask();
    private final CountDownLatch latch;

    public MultithreadedTester(int taskRuns, int threads, ExecutorService executorService) {
        System.out.println("Creating Multithreaded test for " + threads + " threads");
        this.threads = threads;
        this.loop = taskRuns / threads;
        this.executorService = executorService;
        this.latch = new CountDownLatch(threads);
    }

    void execute() throws InterruptedException {
        Stopwatch stopwatch = SimonManager.getStopwatch((String)NAME);
        for (int i = 1; i <= this.threads; ++i) {
            this.startTask();
            if (i % 500 != 0) continue;
            System.out.println("Created thread: " + i + " (already executed loops " + stopwatch.getCounter() + ", currently active " + stopwatch.getActive() + ")");
        }
        System.out.println("All threads created (already executed loops " + stopwatch.getCounter() + ", currently active " + stopwatch.getActive() + ")");
        this.latch.await();
        System.out.println("All threads finished: " + stopwatch.sample());
    }

    private void startTask() {
        if (this.executorService == null) {
            new Thread(this.task).start();
        } else {
            this.executorService.submit(this.task);
        }
    }

    class TestTask
    implements Runnable {
        TestTask() {
        }

        @Override
        public void run() {
            for (int i = 0; i < MultithreadedTester.this.loop; ++i) {
                SimonManager.getStopwatch((String)NAME).start().stop();
            }
            MultithreadedTester.this.latch.countDown();
        }
    }
}

