/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.monitor.LocalMapOperationStats;
import com.hazelcast.partition.Partition;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;

public class SimpleMapTest {
    public static final int STATS_SECONDS = 10;
    public static int THREAD_COUNT = 40;
    public static int ENTRY_COUNT = 10000;
    public static int VALUE_SIZE = 1000;
    public static int GET_PERCENTAGE = 40;
    public static int PUT_PERCENTAGE = 40;
    private static final String NAMESPACE = "default";
    private static final ILogger logger = Logger.getLogger("SimpleMapTest");

    public static boolean parse(String ... input) {
        boolean load = false;
        if (input != null && input.length > 0) {
            String[] stringArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if ((arg = arg.trim()).startsWith("t")) {
                    THREAD_COUNT = Integer.parseInt(arg.substring(1));
                } else if (arg.startsWith("c")) {
                    ENTRY_COUNT = Integer.parseInt(arg.substring(1));
                } else if (arg.startsWith("v")) {
                    VALUE_SIZE = Integer.parseInt(arg.substring(1));
                } else if (arg.startsWith("g")) {
                    GET_PERCENTAGE = Integer.parseInt(arg.substring(1));
                } else if (arg.startsWith("p")) {
                    PUT_PERCENTAGE = Integer.parseInt(arg.substring(1));
                } else if (arg.startsWith("load")) {
                    load = true;
                }
                ++n2;
            }
        } else {
            logger.log(Level.INFO, "Help: sh test.sh t200 v130 p10 g85 ");
            logger.log(Level.INFO, "    // means 200 threads, value-size 130 bytes, 10% put, 85% get");
            logger.log(Level.INFO, "");
        }
        return load;
    }

    public static void main(String[] args) throws InterruptedException {
        boolean load = SimpleMapTest.parse(args);
        logger.log(Level.INFO, "Starting Test with ");
        SimpleMapTest.printVariables();
        ITopic<String> commands = Hazelcast.getTopic(NAMESPACE);
        commands.addMessageListener(new MessageListener<String>(){

            @Override
            public void onMessage(Message<String> stringMessage) {
                SimpleMapTest.parse(stringMessage.getMessageObject());
                SimpleMapTest.printVariables();
            }
        });
        ExecutorService es = Executors.newFixedThreadPool(THREAD_COUNT);
        SimpleMapTest.startPrintStats();
        if (load) {
            SimpleMapTest.load(es);
        }
        SimpleMapTest.run(es);
    }

    private static void run(ExecutorService es) {
        final IMap map = Hazelcast.getMap(NAMESPACE);
        int i = 0;
        while (i < THREAD_COUNT) {
            es.execute(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                int key = (int)(Math.random() * (double)ENTRY_COUNT);
                                int operation = (int)(Math.random() * 100.0);
                                if (operation < GET_PERCENTAGE) {
                                    map.get(String.valueOf(key));
                                    continue;
                                }
                                if (operation < GET_PERCENTAGE + PUT_PERCENTAGE) {
                                    map.put(String.valueOf(key), new byte[VALUE_SIZE]);
                                    continue;
                                }
                                map.remove(String.valueOf(key));
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            });
            ++i;
        }
    }

    private static void load(ExecutorService es) throws InterruptedException {
        final IMap map = Hazelcast.getMap(NAMESPACE);
        Member thisMember = Hazelcast.getCluster().getLocalMember();
        LinkedList<String> lsOwnedEntries = new LinkedList<String>();
        int i = 0;
        while (i < ENTRY_COUNT) {
            String key = String.valueOf(i);
            Partition partition = Hazelcast.getPartitionService().getPartition(key);
            if (thisMember.equals(partition.getOwner())) {
                lsOwnedEntries.add(key);
            }
            ++i;
        }
        final CountDownLatch latch = new CountDownLatch(lsOwnedEntries.size());
        for (final String ownedKey : lsOwnedEntries) {
            es.execute(new Runnable(){

                @Override
                public void run() {
                    map.put(ownedKey, new byte[VALUE_SIZE]);
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    private static void startPrintStats() {
        final IMap map = Hazelcast.getMap(NAMESPACE);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                        logger.log(Level.INFO, "cluster size:" + Hazelcast.getCluster().getMembers().size());
                        LocalMapOperationStats mapOpStats = (LocalMapOperationStats)map.getLocalMapStats().getOperationStats();
                        long period = (mapOpStats.getPeriodEnd() - mapOpStats.getPeriodStart()) / 1000L;
                        if (period == 0L) continue;
                        logger.log(Level.INFO, mapOpStats.toString());
                        logger.log(Level.INFO, "Operations per Second : " + mapOpStats.total() / period);
                    }
                }
                catch (InterruptedException ignored) {
                    return;
                }
            }
        });
    }

    private static void printVariables() {
        logger.log(Level.INFO, "      Thread Count: " + THREAD_COUNT);
        logger.log(Level.INFO, "       Entry Count: " + ENTRY_COUNT);
        logger.log(Level.INFO, "        Value Size: " + VALUE_SIZE);
        logger.log(Level.INFO, "    Get Percentage: " + GET_PERCENTAGE);
        logger.log(Level.INFO, "    Put Percentage: " + PUT_PERCENTAGE);
        logger.log(Level.INFO, " Remove Percentage: " + (100 - (PUT_PERCENTAGE + GET_PERCENTAGE)));
    }
}

