/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.multimap.operations.client.TxnMultiMapRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class TxnMultiMapRemoveAllRequest
extends TxnMultiMapRequest {
    Data key;

    public TxnMultiMapRemoveAllRequest() {
    }

    public TxnMultiMapRemoveAllRequest(String name, Data key, int clientThreadId) {
        super(name, clientThreadId);
        this.key = key;
    }

    @Override
    public Object innerCall() throws Exception {
        TransactionContext context = this.getEndpoint().getTransactionContext();
        TransactionalMultiMap multiMap = context.getMultiMap(this.name);
        Collection objects = multiMap.remove(this.key);
        Collection<Data> coll = this.createCollection(objects.size());
        for (Object object : objects) {
            Data data = this.toData(object);
            coll.add(data);
        }
        return new PortableCollection(coll);
    }

    @Override
    public int getClassId() {
        return 24;
    }

    private Collection<Data> createCollection(int size) {
        MultiMapConfig config = this.getClientEngine().getConfig().findMultiMapConfig(this.name);
        if (config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.SET)) {
            return new HashSet<Data>(size);
        }
        if (config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.LIST)) {
            return new ArrayList<Data>(size);
        }
        return null;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "remove");
    }
}

