/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.FontMetric;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AdobeFontMetricParser
extends AbstractParser {
    private static final long serialVersionUID = -4820306522217196835L;
    private static final MediaType AFM_TYPE = MediaType.application("x-font-adobe-metric");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(AFM_TYPE);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        AFMParser parser = new AFMParser(stream);
        parser.parse();
        FontMetric fontMetrics = parser.getResult();
        List<String> comments = fontMetrics.getComments();
        this.extractCreationDate(metadata, comments);
        metadata.set("Content-Type", AFM_TYPE.toString());
        metadata.set(TikaCoreProperties.TITLE, fontMetrics.getFullName());
        this.addMetadataByString(metadata, "AvgCharacterWidth", Float.toString(fontMetrics.getAverageCharacterWidth()));
        this.addMetadataByString(metadata, "DocVersion", Float.toString(fontMetrics.getAFMVersion()));
        this.addMetadataByString(metadata, "FontName", fontMetrics.getFontName());
        this.addMetadataByString(metadata, "FontFullName", fontMetrics.getFullName());
        this.addMetadataByString(metadata, "FontFamilyName", fontMetrics.getFamilyName());
        this.addMetadataByString(metadata, "FontVersion", fontMetrics.getFontVersion());
        this.addMetadataByString(metadata, "FontWeight", fontMetrics.getWeight());
        this.addMetadataByString(metadata, "FontNotice", fontMetrics.getNotice());
        this.addMetadataByString(metadata, "FontUnderlineThickness", Float.toString(fontMetrics.getUnderlineThickness()));
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        if (comments.size() > 0) {
            xhtml.element("h1", "Comments");
            xhtml.startElement("div", "class", "comments");
            for (String comment : comments) {
                xhtml.element("p", comment);
            }
            xhtml.endElement("div");
        }
        xhtml.endDocument();
    }

    private void addMetadataByString(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, value);
        }
    }

    private void addMetadataByProperty(Metadata metadata, Property property, String value) {
        if (value != null) {
            metadata.set(property, value);
        }
    }

    private void extractCreationDate(Metadata metadata, List<String> comments) {
        String date = null;
        for (String value : comments) {
            if (!value.matches(".*Creation\\sDate.*")) continue;
            date = value.substring(value.indexOf(":") + 2);
            comments.remove(value);
            break;
        }
        if (date != null) {
            this.addMetadataByProperty(metadata, Metadata.CREATION_DATE, date);
        }
    }
}

