/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.javasimon.Simon;
import org.javasimon.SimonManager;
import org.javasimon.Split;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimonUtils {
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long NANOS_IN_MILLIS = 1000000L;
    public static final String NAME_PATTERN_CHAR_CLASS_CONTENT = "-_\\[\\]A-Za-z0-9.,@$%()<>";
    public static final Pattern NAME_PATTERN = Pattern.compile("[-_\\[\\]A-Za-z0-9.,@$%()<>]*");
    public static final String ALLOWED_CHARS = "-_[]ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789.,@$%()<>";
    public static final String MANAGER_SERVLET_CTX_ATTRIBUTE = "manager-servlet-ctx-attribute";
    public static final long INIT_NANOS;
    public static final long INIT_MILLIS;
    private static final SimpleDateFormat TIMESTAMP_FORMAT;
    private static final int UNIT_PREFIX_FACTOR = 1000;
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS;
    private static final int TEN = 10;
    private static final DecimalFormat UNDER_TEN_FORMAT;
    private static final int HUNDRED = 100;
    private static final DecimalFormat UNDER_HUNDRED_FORMAT;
    private static final DecimalFormat DEFAULT_FORMAT;
    private static final String UNDEF_STRING = "undef";
    private static final int CLIENT_CODE_STACK_INDEX;
    private static final String SHRINKED_STRING = "...";

    private SimonUtils() {
        throw new UnsupportedOperationException();
    }

    public static String presentNanoTime(long nanos) {
        if (nanos == Long.MAX_VALUE) {
            return UNDEF_STRING;
        }
        return SimonUtils.presentOverNanoTime(nanos);
    }

    public static String presentNanoTime(double nanos) {
        if (nanos == Double.MAX_VALUE) {
            return UNDEF_STRING;
        }
        return SimonUtils.presentOverNanoTime(nanos);
    }

    private static String presentOverNanoTime(double time) {
        if (Math.abs(time) < 1.0) {
            return "0";
        }
        if (time < 1000.0) {
            return (long)time + " ns";
        }
        if ((time /= 1000.0) < 1000.0) {
            return SimonUtils.formatTime(time, " us");
        }
        if ((time /= 1000.0) < 1000.0) {
            return SimonUtils.formatTime(time, " ms");
        }
        return SimonUtils.formatTime(time /= 1000.0, " s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatTime(double time, String unit) {
        if (time < 10.0) {
            DecimalFormat decimalFormat = UNDER_TEN_FORMAT;
            synchronized (decimalFormat) {
                return UNDER_TEN_FORMAT.format(time) + unit;
            }
        }
        if (time < 100.0) {
            DecimalFormat decimalFormat = UNDER_HUNDRED_FORMAT;
            synchronized (decimalFormat) {
                return UNDER_HUNDRED_FORMAT.format(time) + unit;
            }
        }
        DecimalFormat decimalFormat = DEFAULT_FORMAT;
        synchronized (decimalFormat) {
            return DEFAULT_FORMAT.format(time) + unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String presentTimestamp(long timestamp) {
        if (timestamp == 0L) {
            return UNDEF_STRING;
        }
        SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMAT;
        synchronized (simpleDateFormat) {
            return TIMESTAMP_FORMAT.format(new Date(timestamp));
        }
    }

    public static String presentMinMaxCount(long minmax) {
        if (minmax == Long.MAX_VALUE || minmax == Long.MIN_VALUE) {
            return UNDEF_STRING;
        }
        return String.valueOf(minmax);
    }

    public static String presentMinMaxSplit(long minmax) {
        if (minmax == Long.MAX_VALUE || minmax == Long.MIN_VALUE) {
            return UNDEF_STRING;
        }
        return SimonUtils.presentNanoTime(minmax);
    }

    public static String simonTreeString(Simon simon) {
        if (simon == null || simon.getName() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        SimonUtils.printSimonTree(0, simon, sb);
        return sb.toString();
    }

    private static void printSimonTree(int level, Simon simon, StringBuilder sb) {
        SimonUtils.printSimon(level, simon, sb);
        for (Simon child : simon.getChildren()) {
            SimonUtils.printSimonTree(level + 1, child, sb);
        }
    }

    private static void printSimon(int level, Simon simon, StringBuilder sb) {
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(SimonUtils.localName(simon.getName())).append('(').append(simon.isEnabled() ? (char)'+' : '-').append("): ").append(simon.toString()).append('\n');
    }

    public static String localName(String name) {
        int ix = name.lastIndexOf(".");
        if (ix == -1) {
            return name;
        }
        return name.substring(ix + 1);
    }

    public static void recursiveReset(Simon simon) {
        simon.reset();
        for (Simon child : simon.getChildren()) {
            SimonUtils.recursiveReset(child);
        }
    }

    public static boolean checkName(String name) {
        return NAME_PATTERN.matcher(name).matches();
    }

    public static String generateNameForClass(String suffix) {
        return SimonUtils.generatePrivate(suffix, false);
    }

    public static String generateNameForClassAndMethod(String suffix) {
        return SimonUtils.generatePrivate(suffix, true);
    }

    private static String generatePrivate(String suffix, boolean includeMethodName) {
        StackTraceElement stackElement = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX];
        StringBuilder nameBuilder = new StringBuilder(stackElement.getClassName());
        if (includeMethodName) {
            nameBuilder.append('.').append(stackElement.getMethodName());
        }
        if (suffix != null) {
            nameBuilder.append(suffix);
        }
        return nameBuilder.toString();
    }

    public static String generateName() {
        return SimonUtils.generatePrivate(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doWithStopwatch(String name, Callable<T> callable) throws Exception {
        Split split = SimonManager.getStopwatch(name).start();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            split.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithStopwatch(String name, Runnable runnable) {
        Split split = SimonManager.getStopwatch(name).start();
        try {
            runnable.run();
        }
        finally {
            split.stop();
        }
    }

    public static String compact(String input, int limitTo) {
        if (input == null || input.length() <= limitTo) {
            return input;
        }
        int headLength = limitTo / 2;
        int tailLength = limitTo - SHRINKED_STRING.length() - headLength;
        if (tailLength < 0) {
            tailLength = 1;
        }
        return input.substring(0, headLength) + SHRINKED_STRING + input.substring(input.length() - tailLength);
    }

    public static long millisForNano(long nanos) {
        return INIT_MILLIS + (nanos - INIT_NANOS) / 1000000L;
    }

    static {
        TIMESTAMP_FORMAT = new SimpleDateFormat("yyMMdd-HHmmss.SSS");
        DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
        UNDER_TEN_FORMAT = new DecimalFormat("0.00", DECIMAL_FORMAT_SYMBOLS);
        UNDER_HUNDRED_FORMAT = new DecimalFormat("00.0", DECIMAL_FORMAT_SYMBOLS);
        DEFAULT_FORMAT = new DecimalFormat("000", DECIMAL_FORMAT_SYMBOLS);
        int i = 1;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            ++i;
            if (ste.getClassName().equals(SimonUtils.class.getName())) break;
        }
        CLIENT_CODE_STACK_INDEX = i;
        INIT_NANOS = System.nanoTime();
        INIT_MILLIS = System.currentTimeMillis();
    }
}

