/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.executor;

import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.logging.ILogger;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ParallelExecutorService {
    private final ExecutorService executorService;
    private final List<ParallelExecutor> lsParallelExecutors = new CopyOnWriteArrayList<ParallelExecutor>();
    private final ILogger logger;

    public ParallelExecutorService(ILogger logger, ExecutorService executorService) {
        this.executorService = executorService;
        this.logger = logger;
    }

    public void shutdown() {
        for (ParallelExecutor parallelExecutor : this.lsParallelExecutors) {
            parallelExecutor.shutdown();
        }
        this.lsParallelExecutors.clear();
    }

    public ParallelExecutor newBlockingParallelExecutor(int concurrencyLevel, int capacity) {
        ParallelExecutorImpl p = new ParallelExecutorImpl(concurrencyLevel, capacity);
        this.lsParallelExecutors.add(p);
        return p;
    }

    public ParallelExecutor newParallelExecutor(int concurrencyLevel) {
        ParallelExecutor parallelExecutor = concurrencyLevel > 0 && concurrencyLevel < Integer.MAX_VALUE ? new ParallelExecutorImpl(concurrencyLevel, Integer.MAX_VALUE) : new FullyParallelExecutorImpl();
        this.lsParallelExecutors.add(parallelExecutor);
        return parallelExecutor;
    }

    class FullyParallelExecutorImpl
    implements ParallelExecutor {
        FullyParallelExecutorImpl() {
        }

        @Override
        public void execute(Runnable command) {
            ParallelExecutorService.this.executorService.execute(command);
        }

        @Override
        public void execute(Runnable command, int hash) {
            ParallelExecutorService.this.executorService.execute(command);
        }

        @Override
        public void shutdown() {
        }

        @Override
        public int getPoolSize() {
            return 0;
        }

        @Override
        public int getActiveCount() {
            return 0;
        }
    }

    private class ParallelExecutorImpl
    implements ParallelExecutor {
        private final ExecutionSegment[] executionSegments;
        private final AtomicInteger offerIndex = new AtomicInteger();
        private final AtomicInteger activeCount = new AtomicInteger();

        private ParallelExecutorImpl(int concurrencyLevel, int segmentCapacity) {
            this.executionSegments = new ExecutionSegment[concurrencyLevel];
            int i = 0;
            while (i < concurrencyLevel) {
                this.executionSegments[i] = new ExecutionSegment(segmentCapacity);
                ++i;
            }
        }

        @Override
        public void execute(Runnable command) {
            int hash = this.offerIndex.incrementAndGet();
            this.execute(command, hash);
        }

        @Override
        public void execute(Runnable command, int hash) {
            if (command == null) {
                throw new NullPointerException("Runnable is not allowed to be null");
            }
            int index = hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.executionSegments.length;
            ExecutionSegment segment = this.executionSegments[index];
            segment.offer(command);
        }

        @Override
        public void shutdown() {
            ExecutionSegment[] executionSegmentArray = this.executionSegments;
            int n = this.executionSegments.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionSegment executionSegment = executionSegmentArray[n2];
                executionSegment.shutdown();
                ++n2;
            }
        }

        @Override
        public int getPoolSize() {
            int size = 0;
            ExecutionSegment[] executionSegmentArray = this.executionSegments;
            int n = this.executionSegments.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionSegment executionSegment = executionSegmentArray[n2];
                size += executionSegment.getPoolSize();
                ++n2;
            }
            return size;
        }

        @Override
        public int getActiveCount() {
            return this.activeCount.get();
        }

        private class ExecutionSegment
        implements Runnable {
            private final BlockingQueue<Runnable> q;
            private final AtomicBoolean active = new AtomicBoolean(false);

            private ExecutionSegment(int capacity) {
                this.q = new LinkedBlockingQueue<Runnable>(capacity);
            }

            private void offer(Runnable command) {
                boolean interrupted = false;
                try {
                    while (true) {
                        try {
                            this.q.put(command);
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.active.get()) {
                    return;
                }
                if (this.active.compareAndSet(false, true)) {
                    ParallelExecutorService.this.executorService.execute(this);
                }
            }

            @Override
            public void run() {
                ParallelExecutorImpl.this.activeCount.incrementAndGet();
                try {
                    while (true) {
                        Runnable command;
                        if ((command = (Runnable)this.q.poll()) == null) {
                            boolean finished;
                            this.active.set(false);
                            if (this.q.peek() == null) {
                                finished = true;
                            } else {
                                boolean bl = finished = !this.active.compareAndSet(false, true);
                            }
                            if (!finished) continue;
                            break;
                        }
                        try {
                            command.run();
                        }
                        catch (Throwable e) {
                            ParallelExecutorService.this.logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    ParallelExecutorImpl.this.activeCount.decrementAndGet();
                }
            }

            private void shutdown() {
                Runnable r = (Runnable)this.q.poll();
                while (r != null) {
                    r = (Runnable)this.q.poll();
                }
            }

            private int getPoolSize() {
                return this.active.get() ? 1 : 0;
            }
        }
    }
}

