/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.concurrentmap.ValueHolder;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Values
implements Collection,
DataSerializable {
    Collection<Data> lsValues = null;

    public Values() {
    }

    public Values(Collection<ValueHolder> values) {
        if (values != null) {
            this.lsValues = new ArrayList<Data>(values.size());
            for (ValueHolder valueHolder : values) {
                if (valueHolder == null) continue;
                this.lsValues.add(valueHolder.getData());
            }
        }
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Contains cannot have null argument.");
        }
        for (Object v : this) {
            if (!o.equals(v)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator iterator() {
        return new ValueIterator(this.lsValues.iterator());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.lsValues == null ? 0 : this.lsValues.size();
    }

    @Override
    public Object[] toArray() {
        if (this.size() == 0) {
            return null;
        }
        return this.toArray(new Object[this.size()]);
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        if (a == null || a.length < size) {
            a = new Object[size];
        }
        Iterator<Data> it = this.lsValues.iterator();
        int index = 0;
        while (it.hasNext()) {
            a[index++] = IOUtil.toObject(it.next());
        }
        return a;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        int size = in.readInt();
        this.lsValues = new ArrayList<Data>(size);
        int i = 0;
        while (i < size) {
            Data data = new Data();
            data.readData(in);
            this.lsValues.add(data);
            ++i;
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        int size = this.lsValues == null ? 0 : this.lsValues.size();
        out.writeInt(size);
        if (size > 0) {
            for (Data data : this.lsValues) {
                data.writeData(out);
            }
        }
    }

    public String toString() {
        Iterator i = this.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            sb.append((Object)((e = i.next()) == this ? "(this Collection)" : e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    class ValueIterator
    implements Iterator {
        final Iterator<Data> it;

        public ValueIterator(Iterator<Data> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            Data value = this.it.next();
            return IOUtil.toObject(value);
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

