/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;

public abstract class PageBtree
extends Page {
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageBtreeIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int[] offsets;
    protected int entryCount;
    protected SearchRow[] rows;
    protected int start;
    protected boolean onlyPosition;
    protected boolean written;
    protected int memoryEstimated;

    PageBtree(PageBtreeIndex pageBtreeIndex, int n, Data data) {
        this.index = pageBtreeIndex;
        this.data = data;
        this.setPos(n);
        this.memoryEstimated = pageBtreeIndex.getMemoryPerPage();
    }

    abstract int getRowCount();

    abstract void setRowCountStored(int var1);

    int find(SearchRow searchRow, boolean bl, boolean bl2, boolean bl3) {
        if (searchRow == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.entryCount;
        int n3 = 1;
        while (n < n2) {
            int n4 = n + n2 >>> 1;
            SearchRow searchRow2 = this.getRow(n4);
            n3 = this.index.compareRows(searchRow2, searchRow);
            if (n3 == 0) {
                if (bl2 && this.index.indexType.isUnique() && !this.index.containsNullAndAllowMultipleNull(searchRow)) {
                    throw this.index.getDuplicateKeyException();
                }
                if (bl3 && (n3 = this.index.compareKeys(searchRow2, searchRow)) == 0) {
                    return n4;
                }
            }
            if (n3 > 0 || !bl && n3 == 0) {
                n2 = n4;
                continue;
            }
            n = n4 + 1;
        }
        return n;
    }

    abstract int addRowTry(SearchRow var1);

    abstract void find(PageBtreeCursor var1, SearchRow var2, boolean var3);

    abstract void last(PageBtreeCursor var1);

    SearchRow getRow(int n) {
        SearchRow searchRow = this.rows[n];
        if (searchRow == null) {
            searchRow = this.index.readRow(this.data, this.offsets[n], this.onlyPosition, true);
            this.memoryChange();
            this.rows[n] = searchRow;
        } else if (!this.index.hasData(searchRow)) {
            searchRow = this.index.readRow(searchRow.getKey());
            this.memoryChange();
            this.rows[n] = searchRow;
        }
        return searchRow;
    }

    protected void memoryChange() {
    }

    abstract PageBtree split(int var1);

    void setPageId(int n) {
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(n);
        this.index.getPageStore().logUndo(this, null);
        this.remapChildren();
    }

    abstract PageBtreeLeaf getFirstLeaf();

    abstract PageBtreeLeaf getLastLeaf();

    void setParentPageId(int n) {
        this.index.getPageStore().logUndo(this, this.data);
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        this.parentPageId = n;
    }

    abstract void remapChildren();

    abstract SearchRow remove(SearchRow var1);

    abstract void freeRecursive();

    protected void readAllRows() {
        for (int i = 0; i < this.entryCount; ++i) {
            SearchRow searchRow = this.rows[i];
            if (searchRow != null) continue;
            this.rows[i] = searchRow = this.index.readRow(this.data, this.offsets[i], this.onlyPosition, false);
        }
    }

    @Override
    public int getMemory() {
        return this.memoryEstimated;
    }

    @Override
    public boolean canRemove() {
        return this.changeCount < this.index.getPageStore().getChangeCount();
    }
}

