/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.hibernate;

import com.hazelcast.hibernate.HazelcastCacheRegionFactory;
import com.hazelcast.hibernate.HazelcastLocalCacheRegionFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RegionFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        NamedNodeMap atts = element.getAttributes();
        String instanceRefName = "instance";
        String mode = "DISTRIBUTED";
        if (atts != null) {
            for (int a = 0; a < atts.getLength(); ++a) {
                Node att = atts.item(a);
                String name = att.getNodeName();
                if ("instance-ref".equals(name)) {
                    instanceRefName = att.getTextContent();
                    continue;
                }
                if (!"mode".equals(name)) continue;
                mode = att.getTextContent();
            }
        }
        if ("DISTRIBUTED".equals(mode)) {
            builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastCacheRegionFactory.class);
        } else if ("LOCAL".equals(mode)) {
            builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastLocalCacheRegionFactory.class);
        } else {
            throw new IllegalArgumentException("Unknown Hibernate L2 cache mode: " + mode);
        }
        builder.addConstructorArgReference(instanceRefName);
        return builder.getBeanDefinition();
    }
}

