/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class MultiTargetClientRequest
extends ClientRequest {
    @Override
    final void process() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        OperationFactory operationFactory = this.createOperationFactory();
        Collection<Address> targets = this.getTargets();
        if (targets.isEmpty()) {
            this.clientEngine.sendResponse(this.getEndpoint(), this.reduce(new HashMap<Address, Object>()));
            return;
        }
        MultiTargetCallback callback = new MultiTargetCallback(targets);
        for (Address target : targets) {
            Operation op = operationFactory.createOperation();
            op.setCallerUuid(endpoint.getUuid());
            InvocationBuilder builder = this.clientEngine.createInvocationBuilder(this.getServiceName(), op, target).setTryCount(100).setCallback(new SingleTargetCallback(target, callback));
            Invocation inv = builder.build();
            inv.invoke();
        }
    }

    protected abstract OperationFactory createOperationFactory();

    protected abstract Object reduce(Map<Address, Object> var1);

    public abstract Collection<Address> getTargets();

    private class SingleTargetCallback
    implements Callback<Object> {
        final Address target;
        final MultiTargetCallback parent;

        private SingleTargetCallback(Address target, MultiTargetCallback parent) {
            this.target = target;
            this.parent = parent;
        }

        @Override
        public void notify(Object object) {
            this.parent.notify(this.target, object);
        }
    }

    private class MultiTargetCallback {
        final Collection<Address> targets;
        final ConcurrentMap<Address, Object> results;

        private MultiTargetCallback(Collection<Address> targets) {
            this.targets = Collections.synchronizedSet(new HashSet<Address>(targets));
            this.results = new ConcurrentHashMap<Address, Object>(targets.size());
        }

        public void notify(Address target, Object result) {
            if (!this.targets.remove(target)) {
                if (this.results.containsKey(target)) {
                    throw new IllegalArgumentException("Duplicate response from -> " + target);
                }
                throw new IllegalArgumentException("Unknown target! -> " + target);
            }
            this.results.put(target, result);
            if (this.targets.isEmpty()) {
                Object response = MultiTargetClientRequest.this.reduce(this.results);
                MultiTargetClientRequest.this.clientEngine.sendResponse(MultiTargetClientRequest.this.getEndpoint(), response);
            }
        }
    }
}

