/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.security;

import com.hazelcast.util.Base64;
import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class RFC2104HMAC {
    public static String calculateRFC2104HMAC(String data, String key) throws SignatureException {
        String result = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] rawSignature = mac.doFinal(data.getBytes());
            result = new String(Base64.encode(rawSignature));
            result = result.trim();
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }
}

