/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.Node;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.nio.Address;
import java.util.Hashtable;

@ManagedDescription(value="HazelcastInstance.Node")
public class NodeMBean
extends HazelcastMBean<Node> {
    public NodeMBean(HazelcastInstance hazelcastInstance, Node node, ManagementService service) {
        super(node, service);
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("type", ManagementService.quote("HazelcastInstance.Node"));
        properties.put("name", ManagementService.quote("node" + node.address));
        properties.put("instance", ManagementService.quote(hazelcastInstance.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="address")
    @ManagedDescription(value="Address of the node")
    public String getName() {
        return ((Node)this.managedObject).address.toString();
    }

    @ManagedAnnotation(value="masterAddress")
    @ManagedDescription(value="The master address of the cluster")
    public String getMasterAddress() {
        Address a = ((Node)this.managedObject).getMasterAddress();
        return a == null ? null : a.toString();
    }
}

