/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.inifile;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.antcontrib.inifile.IniPart;
import net.sf.antcontrib.inifile.IniProperty;

public class IniSection
implements IniPart {
    private String name;
    private List properties;
    private Map propertyMap = new HashMap();

    public IniSection() {
        this.properties = new ArrayList();
    }

    public IniSection(String string) {
        this();
        this.name = string;
    }

    public List getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void write(Writer writer) throws IOException {
        writer.write("[" + this.name + "]");
        writer.write(System.getProperty("line.separator"));
        Iterator iterator = this.properties.iterator();
        IniProperty iniProperty = null;
        while (iterator.hasNext()) {
            iniProperty = (IniProperty)iterator.next();
            iniProperty.write(writer);
            writer.write(System.getProperty("line.separator"));
        }
    }

    public IniProperty getProperty(String string) {
        return (IniProperty)this.propertyMap.get(string);
    }

    public void setProperty(IniProperty iniProperty) {
        IniProperty iniProperty2 = (IniProperty)this.propertyMap.get(iniProperty.getName());
        if (iniProperty2 != null) {
            int n = this.properties.indexOf(iniProperty2);
            this.properties.set(n, iniProperty);
        } else {
            this.properties.add(iniProperty);
        }
        this.propertyMap.put(iniProperty.getName(), iniProperty);
    }

    public void removeProperty(String string) {
        IniProperty iniProperty = (IniProperty)this.propertyMap.get(string);
        if (iniProperty != null) {
            int n = this.properties.indexOf(iniProperty);
            this.properties.remove(n);
            this.propertyMap.remove(string);
        }
    }
}

