/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.transform.DelegatingNamespaceContext;
import org.apache.cxf.staxutils.transform.ElementProperty;
import org.apache.cxf.staxutils.transform.QNamesMap;
import org.apache.cxf.staxutils.transform.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InTransformReader
extends DepthXMLStreamReader {
    private static final Logger LOG = LogUtils.getLogger(InTransformReader.class);
    private static final String INTERN_NAMES = "org.codehaus.stax2.internNames";
    private static final String INTERN_NS = "org.codehaus.stax2.internNsUris";
    private QNamesMap inElementsMap;
    private QNamesMap inAttributesMap;
    private Map<QName, ElementProperty> inAppendMap = new HashMap<QName, ElementProperty>(5);
    private Set<QName> inDropSet = new HashSet<QName>(5);
    private Map<String, String> nsMap = new HashMap<String, String>(5);
    private Stack<ParsingEvent> pushedBackEvents = new Stack();
    private Map<EndEventMarker, List<ParsingEvent>> pushedAheadEvents = new HashMap<EndEventMarker, List<ParsingEvent>>();
    private String replaceText;
    private ParsingEvent currentEvent;
    private List<Integer> attributesIndexes = new ArrayList<Integer>();
    private boolean blockOriginalReader = true;
    private boolean attributesIndexed;
    private DelegatingNamespaceContext namespaceContext;

    public InTransformReader(XMLStreamReader reader, Map<String, String> inMap, Map<String, String> appendMap, boolean blockOriginalReader) {
        this(reader, inMap, appendMap, null, null, blockOriginalReader);
    }

    public InTransformReader(XMLStreamReader reader, Map<String, String> inEMap, Map<String, String> appendMap, List<String> dropESet, Map<String, String> inAMap, boolean blockOriginalReader) {
        super(reader);
        this.inElementsMap = new QNamesMap(inEMap == null ? 0 : inEMap.size());
        this.inAttributesMap = new QNamesMap(inAMap == null ? 0 : inAMap.size());
        this.blockOriginalReader = blockOriginalReader;
        TransformUtils.convertToQNamesMap(inEMap, this.inElementsMap, this.nsMap);
        TransformUtils.convertToQNamesMap(inAMap, this.inAttributesMap, null);
        TransformUtils.convertToMapOfElementProperties(appendMap, this.inAppendMap);
        TransformUtils.convertToSetOfQNames(dropESet, this.inDropSet);
        this.namespaceContext = new DelegatingNamespaceContext(reader.getNamespaceContext(), this.nsMap);
    }

    @Override
    public XMLStreamReader getReader() {
        return this.blockOriginalReader ? this : super.getReader();
    }

    @Override
    public int next() throws XMLStreamException {
        int event;
        boolean doDebug = LOG.isLoggable(Level.FINE);
        if (!this.pushedBackEvents.empty()) {
            this.currentEvent = this.pushedBackEvents.pop();
            if (doDebug) {
                LOG.fine("pushed event available: " + this.currentEvent);
            }
            return this.currentEvent.event;
        }
        if (doDebug) {
            LOG.fine("no pushed event");
        }
        if ((event = super.next()) == 1) {
            boolean replaceContent;
            this.attributesIndexed = false;
            QName theName = super.getName();
            ElementProperty appendProp = this.inAppendMap.remove(theName);
            boolean bl = replaceContent = appendProp != null && theName.equals(appendProp.getName());
            if (doDebug) {
                LOG.fine("read StartElement " + theName + " at " + this.getDepth());
            }
            boolean dropped = this.inDropSet.contains(theName);
            QName expected = this.inElementsMap.get(theName);
            if (expected == null) {
                expected = theName;
            }
            if (null != appendProp && !replaceContent) {
                this.handleAppendMode(theName, expected, appendProp);
            } else if (replaceContent) {
                this.replaceText = appendProp.getText();
                if (doDebug) {
                    LOG.fine("replacing content with " + this.replaceText);
                }
                this.currentEvent = InTransformReader.createStartElementEvent(expected);
            } else if (dropped) {
                if (doDebug) {
                    LOG.fine("shallow-dropping start " + expected);
                }
                event = this.next();
            } else if (InTransformReader.isEmptyQName(expected)) {
                if (doDebug) {
                    LOG.fine("deep-dropping " + theName);
                }
                this.handleDeepDrop();
                event = this.next();
            } else {
                this.handleDefaultMode(theName, expected);
            }
        } else if (event == 2) {
            boolean dropped;
            QName theName = super.getName();
            if (doDebug) {
                LOG.fine("read EndElement " + theName + " at " + this.getDepth());
            }
            if (!(dropped = this.inDropSet.contains(theName))) {
                EndEventMarker em = new EndEventMarker(theName, this.getDepth() + 1);
                List<ParsingEvent> pe = this.pushedAheadEvents.remove(em);
                if (null != pe) {
                    if (doDebug) {
                        LOG.fine("pushed event found");
                    }
                    this.pushedBackEvents.addAll(pe);
                    this.currentEvent = this.pushedBackEvents.pop();
                    event = this.currentEvent.event;
                } else if (doDebug) {
                    LOG.fine("no pushed event found");
                }
            } else {
                if (doDebug) {
                    LOG.fine("shallow-dropping end " + theName);
                }
                event = this.next();
            }
        } else {
            if (doDebug) {
                LOG.fine("read other event " + event);
            }
            this.currentEvent = null;
        }
        return event;
    }

    private void handleAppendMode(QName name, QName expected, ElementProperty appendProp) {
        boolean doDebug = LOG.isLoggable(Level.FINE);
        if (appendProp.isChild()) {
            if (null == appendProp.getText()) {
                this.pushedBackEvents.push(InTransformReader.createStartElementEvent(appendProp.getName()));
                this.currentEvent = InTransformReader.createStartElementEvent(expected);
                EndEventMarker em = new EndEventMarker(name, this.getDepth());
                if (doDebug) {
                    LOG.fine("ap-post-wrap " + appendProp.getName() + ", " + em);
                }
                ArrayList<ParsingEvent> pe = new ArrayList<ParsingEvent>(2);
                pe.add(InTransformReader.createEndElementEvent(expected));
                pe.add(InTransformReader.createEndElementEvent(appendProp.getName()));
                this.pushedAheadEvents.put(em, pe);
            } else {
                this.currentEvent = InTransformReader.createStartElementEvent(expected);
                EndEventMarker em = new EndEventMarker(name, this.getDepth());
                if (doDebug) {
                    LOG.fine("ap-pre-incl " + appendProp.getName() + "=" + appendProp.getText() + ", " + em);
                }
                ArrayList<ParsingEvent> pe = new ArrayList<ParsingEvent>();
                pe.add(InTransformReader.createEndElementEvent(expected));
                pe.add(InTransformReader.createEndElementEvent(appendProp.getName()));
                pe.add(InTransformReader.createCharactersEvent(appendProp.getText()));
                pe.add(InTransformReader.createStartElementEvent(appendProp.getName()));
                this.pushedAheadEvents.put(em, pe);
            }
        } else if (null == appendProp.getText()) {
            this.pushedBackEvents.push(InTransformReader.createStartElementEvent(expected));
            this.currentEvent = InTransformReader.createStartElementEvent(appendProp.getName());
            EndEventMarker em = new EndEventMarker(name, this.getDepth());
            if (doDebug) {
                LOG.fine("ap-pre-wrap " + appendProp.getName() + ", " + em);
            }
            ArrayList<ParsingEvent> pe = new ArrayList<ParsingEvent>();
            pe.add(InTransformReader.createEndElementEvent(appendProp.getName()));
            pe.add(InTransformReader.createEndElementEvent(expected));
            this.pushedAheadEvents.put(em, pe);
        } else {
            this.pushedBackEvents.push(InTransformReader.createStartElementEvent(expected));
            this.pushedBackEvents.push(InTransformReader.createEndElementEvent(appendProp.getName()));
            this.pushedBackEvents.push(InTransformReader.createCharactersEvent(appendProp.getText()));
            this.currentEvent = InTransformReader.createStartElementEvent(appendProp.getName());
            if (doDebug) {
                LOG.fine("ap-pre-incl " + appendProp.getName() + "=" + appendProp.getText());
            }
        }
    }

    private void handleDefaultMode(QName name, QName expected) {
        this.currentEvent = InTransformReader.createStartElementEvent(expected);
        if (!name.equals(expected)) {
            EndEventMarker em = new EndEventMarker(name, this.getDepth());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("default " + name + "->" + expected + ", " + em);
            }
            ArrayList<ParsingEvent> pe = new ArrayList<ParsingEvent>(1);
            pe.add(InTransformReader.createEndElementEvent(expected));
            this.pushedAheadEvents.put(em, pe);
        }
    }

    private void handleDeepDrop() throws XMLStreamException {
        int depth = this.getDepth();
        while (depth != this.getDepth() || super.next() != 2) {
        }
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (INTERN_NAMES.equals(name) || INTERN_NS.equals(name)) {
            return Boolean.FALSE;
        }
        return super.getProperty(name);
    }

    @Override
    public String getLocalName() {
        if (this.currentEvent != null) {
            return this.currentEvent.name.getLocalPart();
        }
        return super.getLocalName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public String getPrefix() {
        QName name = this.readCurrentElement();
        String prefix = name.getPrefix();
        if (prefix.length() == 0) {
            prefix = this.namespaceContext.findUniquePrefix(name.getNamespaceURI());
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI(int index) {
        String ns = super.getNamespaceURI(index);
        String actualNs = this.nsMap.get(ns);
        if (actualNs != null) {
            return actualNs;
        }
        return ns;
    }

    @Override
    public String getNamespacePrefix(int index) {
        String ns = super.getNamespaceURI(index);
        String actualNs = this.nsMap.get(ns);
        if (actualNs != null) {
            return this.namespaceContext.findUniquePrefix(actualNs);
        }
        return this.namespaceContext.getPrefix(ns);
    }

    @Override
    public String getNamespaceURI() {
        if (this.currentEvent != null) {
            return this.currentEvent.name.getNamespaceURI();
        }
        return super.getNamespaceURI();
    }

    private QName readCurrentElement() {
        if (this.currentEvent != null) {
            return this.currentEvent.name;
        }
        String ns = super.getNamespaceURI();
        String name = super.getLocalName();
        String prefix = super.getPrefix();
        return new QName(ns, name, prefix == null ? "" : prefix);
    }

    @Override
    public QName getName() {
        return new QName(this.getNamespaceURI(), this.getLocalName());
    }

    @Override
    public int getAttributeCount() {
        if (!this.pushedBackEvents.empty()) {
            return 0;
        }
        this.checkAttributeIndexRange(-1);
        return this.attributesIndexes.size();
    }

    @Override
    public String getAttributeLocalName(int arg0) {
        if (!this.pushedBackEvents.empty()) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        return this.getAttributeName(arg0).getLocalPart();
    }

    @Override
    public QName getAttributeName(int arg0) {
        if (!this.pushedBackEvents.empty()) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        QName aname = super.getAttributeName(this.attributesIndexes.get(arg0));
        QName expected = this.inAttributesMap.get(aname);
        return expected == null ? aname : expected;
    }

    @Override
    public String getAttributeNamespace(int arg0) {
        if (!this.pushedBackEvents.empty()) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        return this.getAttributeName(arg0).getNamespaceURI();
    }

    @Override
    public String getAttributePrefix(int arg0) {
        if (!this.pushedBackEvents.empty()) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        QName aname = this.getAttributeName(arg0);
        if ("".equals(aname.getNamespaceURI())) {
            return "";
        }
        String actualNs = this.nsMap.get(aname.getNamespaceURI());
        if (actualNs != null) {
            return this.namespaceContext.findUniquePrefix(actualNs);
        }
        return this.namespaceContext.getPrefix(aname.getNamespaceURI());
    }

    @Override
    public String getAttributeType(int arg0) {
        if (!this.pushedBackEvents.empty()) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        return super.getAttributeType(this.attributesIndexes.get(arg0));
    }

    @Override
    public String getAttributeValue(int arg0) {
        if (!this.pushedBackEvents.empty()) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        return super.getAttributeValue(this.attributesIndexes.get(arg0));
    }

    @Override
    public String getAttributeValue(String namespace, String localName) {
        if (!this.pushedBackEvents.empty()) {
            return null;
        }
        this.checkAttributeIndexRange(-1);
        return super.getAttributeValue(namespace, localName);
    }

    @Override
    public String getText() {
        if (this.currentEvent != null) {
            return this.currentEvent.value;
        }
        String superText = super.getText();
        if (this.replaceText != null) {
            superText = this.replaceText;
            this.replaceText = null;
        }
        return superText;
    }

    @Override
    public char[] getTextCharacters() {
        if (this.currentEvent != null && this.currentEvent != null) {
            return this.currentEvent.value.toCharArray();
        }
        char[] superChars = super.getTextCharacters();
        if (this.replaceText != null) {
            superChars = this.replaceText.toCharArray();
            this.replaceText = null;
        }
        return superChars;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.currentEvent != null && this.currentEvent != null) {
            int len = this.currentEvent.value.length() - sourceStart;
            if (len > length) {
                len = length;
            }
            this.currentEvent.value.getChars(sourceStart, sourceStart + len, target, targetStart);
            return len;
        }
        return super.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextLength() {
        if (this.currentEvent != null && this.currentEvent.value != null) {
            return this.currentEvent.value.length();
        }
        return super.getTextLength();
    }

    private void checkAttributeIndexRange(int index) {
        if (!this.attributesIndexed) {
            this.attributesIndexes.clear();
            int c = super.getAttributeCount();
            for (int i = 0; i < c; ++i) {
                QName aname = super.getAttributeName(i);
                QName expected = this.inAttributesMap.get(aname);
                if (expected != null && InTransformReader.isEmptyQName(expected)) continue;
                this.attributesIndexes.add(i);
            }
            this.attributesIndexed = true;
        }
        if (index >= this.attributesIndexes.size()) {
            this.throwIndexException(index, this.attributesIndexes.size());
        }
    }

    private static boolean isEmptyQName(QName qname) {
        return "".equals(qname.getNamespaceURI()) && "".equals(qname.getLocalPart());
    }

    private void throwIndexException(int index, int size) {
        throw new IllegalArgumentException("Invalid index " + index + "; current element has only " + size + " attributes");
    }

    private static ParsingEvent createStartElementEvent(QName name) {
        return new ParsingEvent(1, name, null);
    }

    private static ParsingEvent createEndElementEvent(QName name) {
        return new ParsingEvent(2, name, null);
    }

    private static ParsingEvent createCharactersEvent(String value) {
        return new ParsingEvent(4, null, value);
    }

    private static class EndEventMarker {
        private QName name;
        private int level;

        public EndEventMarker(QName name, int level) {
            this.name = name;
            this.level = level;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.level;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EndEventMarker) {
                EndEventMarker e = (EndEventMarker)obj;
                return this.name.equals(e.name) && this.level == e.level;
            }
            return false;
        }

        public String toString() {
            return new StringBuffer().append("Marker(").append(this.name).append(", ").append(this.level).append(")").toString();
        }
    }

    private static class ParsingEvent {
        private int event;
        private QName name;
        private String value;

        public ParsingEvent(int event, QName name, String value) {
            this.event = event;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return new StringBuffer().append("Event(").append(this.event).append(", ").append(this.name).append(", ").append(this.value).append(")").toString();
        }
    }
}

