/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.services;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.oauth.data.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth.services.AuthorizationRequestHandler;

@Path(value="/authorize")
public class AuthorizationRequestService
extends AbstractOAuthService {
    private AuthorizationRequestHandler handler = new AuthorizationRequestHandler();

    public void setAuthorizationRequestHandler(AuthorizationRequestHandler h) {
        this.handler = h;
    }

    @GET
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorize() {
        Response response = this.handler.handle(this.getMessageContext(), this.getDataProvider());
        if (response.getEntity() instanceof OAuthAuthorizationData) {
            String replyTo = this.getMessageContext().getUriInfo().getAbsolutePathBuilder().path("decision").build(new Object[0]).toString();
            ((OAuthAuthorizationData)response.getEntity()).setReplyTo(replyTo);
        }
        return response;
    }

    @GET
    @Path(value="/decision")
    public Response authorizeDecision() {
        return this.authorize();
    }

    @POST
    @Path(value="/decision")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authorizeDecisionForm() {
        return this.authorizeDecision();
    }
}

