/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2013 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.drive.json;

import java.util.Comparator;
import com.openexchange.drive.DriveSession;


/**
 * {@link LongPollingListenerFactory}
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 */
public interface LongPollingListenerFactory {

    /**
     * Creates a new {@link LongPollingListener} for the supplied drive session.
     *
     * @param session The drive session
     * @return A new long polling listener instance
     */
    LongPollingListener create(DriveSession session);

    /**
     * Gets the priority of the factory. With multiple factories being present, the factory with the highest priority is chosen when
     * creating new long polling listeners.
     *
     * @return The priority
     */
    int getPriority();

    /**
     * Comparator for the priority of listener factories - "highest priority first".
     */
    static final Comparator<LongPollingListenerFactory> PRIORITY_COMPARATOR = new Comparator<LongPollingListenerFactory>() {

        /**
         * Returns a negative integer, zero, or a positive integer as the first argument is less than, equal to, or greater than the second.
         * @param factory1
         * @param factory2
         * @return
         */
        @Override
        public int compare(LongPollingListenerFactory factory1, LongPollingListenerFactory factory2) {
            if (factory1 == factory2) {
                return 0;
            }
            if (null == factory1) {
                return 1;
            }
            if (null == factory2) {
                return -1;
            }
            return factory2.getPriority() - factory1.getPriority();
        }
    };

}
