/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.config.Config;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Member;
import com.hazelcast.impl.AbstractJoiner;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.SplitBrainHandler;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class TcpIpJoiner
extends AbstractJoiner {
    private static final int MAX_PORT_TRIES = 3;
    volatile boolean approved = true;
    final AtomicInteger responseCounter = new AtomicInteger();
    volatile boolean askingForApproval = false;

    public TcpIpJoiner(Node node) {
        super(node);
    }

    private void joinViaTargetMember(AtomicBoolean joined, Address targetAddress, long maxJoinMillis) {
        try {
            this.logger.log(Level.FINEST, "Joining over target member " + targetAddress);
            if (targetAddress == null) {
                throw new RuntimeException("Invalid target address " + targetAddress);
            }
            if (targetAddress.equals(this.node.address) || this.isLocalAddress(targetAddress)) {
                this.node.setAsMaster();
                return;
            }
            long joinStartTime = Clock.currentTimeMillis();
            Connection connection = null;
            while (this.node.isActive() && !joined.get() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
                connection = this.node.connectionManager.getOrConnect(targetAddress);
                if (connection == null) {
                    Thread.sleep(2000L);
                    continue;
                }
                this.logger.log(Level.FINEST, "Sending joinRequest " + targetAddress);
                this.node.clusterManager.sendJoinRequest(targetAddress, true);
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void joinViaPossibleMembers(AtomicBoolean joined) {
        try {
            this.node.getFailedConnections().clear();
            Collection<Address> colPossibleAddresses = this.getPossibleAddresses();
            colPossibleAddresses.remove(this.node.address);
            for (Address possibleAddress : colPossibleAddresses) {
                this.logger.log(Level.INFO, "Connecting to possible member: " + possibleAddress);
                this.node.connectionManager.getOrConnect(possibleAddress);
            }
            boolean foundConnection = false;
            int numberOfSeconds = 0;
            int connectionTimeoutSeconds = this.config.getNetworkConfig().getJoin().getTcpIpConfig().getConnectionTimeoutSeconds();
            while (!foundConnection && numberOfSeconds < connectionTimeoutSeconds) {
                this.logger.log(Level.FINEST, "Removing failedConnections: " + this.node.getFailedConnections());
                colPossibleAddresses.removeAll(this.node.getFailedConnections());
                if (colPossibleAddresses.size() == 0) break;
                Thread.sleep(1000L);
                ++numberOfSeconds;
                this.logger.log(Level.FINEST, "We are going to try to connect to each address" + colPossibleAddresses);
                for (Address possibleAddress : colPossibleAddresses) {
                    Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
                    if (conn == null) continue;
                    foundConnection = true;
                    this.logger.log(Level.FINEST, "Found and sending join request for " + possibleAddress);
                    this.node.clusterManager.sendJoinRequest(possibleAddress, true);
                }
            }
            this.logger.log(Level.FINEST, "FOUND " + foundConnection);
            if (!foundConnection) {
                this.logger.log(Level.FINEST, "This node will assume master role since no possible member where connected to");
                this.node.setAsMaster();
            } else if (!this.node.joined()) {
                if (connectionTimeoutSeconds - numberOfSeconds > 0) {
                    this.logger.log(Level.FINEST, "Sleeping for " + (connectionTimeoutSeconds - numberOfSeconds) + " seconds.");
                    Thread.sleep((long)(connectionTimeoutSeconds - numberOfSeconds) * 1000L);
                }
                colPossibleAddresses.removeAll(this.node.getFailedConnections());
                if (colPossibleAddresses.size() == 0) {
                    this.logger.log(Level.FINEST, "This node will assume master role since all possible members didn't accept join request");
                    this.node.setAsMaster();
                } else {
                    boolean masterCandidate = true;
                    for (Address address : colPossibleAddresses) {
                        if (this.node.connectionManager.getConnection(address) == null || this.node.address.hashCode() <= address.hashCode()) continue;
                        masterCandidate = false;
                    }
                    if (masterCandidate) {
                        this.askingForApproval = true;
                        for (Address address : colPossibleAddresses) {
                            Connection conn = this.node.getConnectionManager().getConnection(address);
                            if (conn == null) continue;
                            this.responseCounter.incrementAndGet();
                            this.node.clusterManager.sendProcessableTo((RemotelyProcessable)new MasterQuestion(), conn);
                        }
                        int waitCount = 0;
                        while (this.node.isActive() && waitCount++ < 10) {
                            Thread.sleep(1000L);
                            if (this.responseCounter.get() != 0) continue;
                            if (this.approved) {
                                this.logger.log(Level.FINEST, this.node.getThisAddress() + " Setting myself as master! group " + this.node.getConfig().getGroupConfig().getName() + " possible addresses " + colPossibleAddresses.size() + colPossibleAddresses);
                                this.node.setAsMaster();
                                return;
                            }
                            this.lookForMaster(colPossibleAddresses);
                            break;
                        }
                    } else {
                        this.lookForMaster(colPossibleAddresses);
                    }
                }
            }
            colPossibleAddresses.clear();
            this.node.getFailedConnections().clear();
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    private void lookForMaster(Collection<Address> colPossibleAddresses) throws InterruptedException {
        int tryCount = 0;
        while (!this.node.joined() && tryCount++ < 20 && this.node.getMasterAddress() == null) {
            this.connectAndSendJoinRequest(colPossibleAddresses);
            Thread.sleep(1000L);
        }
        int requestCount = 0;
        colPossibleAddresses.removeAll(this.node.getFailedConnections());
        if (colPossibleAddresses.size() == 0) {
            this.node.setAsMaster();
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " Setting myself as master! group " + this.node.getConfig().getGroupConfig().getName() + " no possible addresses without failed connection");
            return;
        }
        this.logger.log(Level.FINEST, this.node.getThisAddress() + " joining to master " + this.node.getMasterAddress() + ", group " + this.node.getConfig().getGroupConfig().getName());
        while (this.node.isActive() && !this.node.joined()) {
            Thread.sleep(1000L);
            Address master = this.node.getMasterAddress();
            if (master != null) {
                this.node.clusterManager.sendJoinRequest(master, true);
                if (requestCount++ <= this.node.getGroupProperties().MAX_WAIT_SECONDS_BEFORE_JOIN.getInteger() + 10) continue;
                this.logger.log(Level.WARNING, "Couldn't join to the master : " + master);
                return;
            }
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " couldn't find a master! but there was connections available: " + colPossibleAddresses);
            return;
        }
    }

    private Address getRequiredMemberAddress() {
        block9: {
            TcpIpConfig tcpIpConfig = this.config.getNetworkConfig().getJoin().getTcpIpConfig();
            String host = tcpIpConfig.getRequiredMember();
            try {
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(host, this.config.getNetworkConfig().getPort());
                if (AddressUtil.isIpAddress(addressHolder.address)) {
                    return new Address(addressHolder.address, addressHolder.port);
                }
                Interfaces interfaces = this.config.getNetworkConfig().getInterfaces();
                if (interfaces.isEnabled()) {
                    InetAddress[] inetAddresses = InetAddress.getAllByName(addressHolder.address);
                    if (inetAddresses.length > 1) {
                        InetAddress[] inetAddressArray = inetAddresses;
                        int n = inetAddresses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            InetAddress inetAddress = inetAddressArray[n2];
                            if (AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) {
                                return new Address(inetAddress, addressHolder.port);
                            }
                            ++n2;
                        }
                    } else {
                        InetAddress inetAddress = inetAddresses[0];
                        if (AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) {
                            return new Address(addressHolder.address, addressHolder.port);
                        }
                    }
                    break block9;
                }
                return new Address(addressHolder.address, addressHolder.port);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public void doJoin(AtomicBoolean joined) {
        if (this.targetAddress != null) {
            try {
                long maxJoinMergeTargetMillis = this.node.getGroupProperties().MAX_JOIN_MERGE_TARGET_SECONDS.getInteger() * 1000;
                this.joinViaTargetMember(joined, this.targetAddress, maxJoinMergeTargetMillis);
            }
            finally {
                this.targetAddress = null;
            }
            if (!joined.get()) {
                this.joinViaPossibleMembers(joined);
            }
        } else if (this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember() != null) {
            Address requiredMember = this.getRequiredMemberAddress();
            long maxJoinMillis = this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
            this.joinViaTargetMember(joined, requiredMember, maxJoinMillis);
        } else {
            this.joinViaPossibleMembers(joined);
        }
    }

    private Collection<Address> getPossibleAddresses() {
        Collection<String> possibleMembers = this.getMembers();
        HashSet<Address> possibleAddresses = new HashSet<Address>();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        for (String possibleMember : possibleMembers) {
            try {
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(possibleMember);
                boolean portIsDefined = addressHolder.port != -1 || !networkConfig.isPortAutoIncrement();
                int count = portIsDefined ? 1 : 3;
                int port = addressHolder.port != -1 ? addressHolder.port : networkConfig.getPort();
                AddressUtil.AddressMatcher addressMatcher = null;
                try {
                    addressMatcher = AddressUtil.getAddressMatcher(addressHolder.address);
                }
                catch (AddressUtil.InvalidAddressException invalidAddressException) {
                    // empty catch block
                }
                if (addressMatcher != null) {
                    Collection<String> matchedAddresses = addressMatcher.isIPv4() ? AddressUtil.getMatchingIpv4Addresses(addressMatcher) : Collections.singleton(addressHolder.address);
                    for (String matchedAddress : matchedAddresses) {
                        this.addPossibleAddresses(possibleAddresses, null, InetAddress.getByName(matchedAddress), port, count);
                    }
                    continue;
                }
                String host = addressHolder.address;
                Interfaces interfaces = networkConfig.getInterfaces();
                if (interfaces.isEnabled()) {
                    InetAddress inetAddress;
                    InetAddress[] inetAddresses = InetAddress.getAllByName(host);
                    if (inetAddresses.length > 1) {
                        InetAddress[] inetAddressArray = inetAddresses;
                        int n = inetAddresses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            inetAddress = inetAddressArray[n2];
                            if (AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) {
                                this.addPossibleAddresses(possibleAddresses, null, inetAddress, port, count);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    inetAddress = inetAddresses[0];
                    if (!AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) continue;
                    this.addPossibleAddresses(possibleAddresses, host, null, port, count);
                    continue;
                }
                this.addPossibleAddresses(possibleAddresses, host, null, port, count);
            }
            catch (UnknownHostException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        possibleAddresses.addAll(networkConfig.getJoin().getTcpIpConfig().getAddresses());
        return possibleAddresses;
    }

    private void addPossibleAddresses(Set<Address> possibleAddresses, String host, InetAddress inetAddress, int port, int count) throws UnknownHostException {
        int i = 0;
        while (i < count) {
            Address address;
            int currentPort = port + i;
            Address address2 = address = host != null ? new Address(host, currentPort) : new Address(inetAddress, currentPort);
            if (!this.isLocalAddress(address)) {
                possibleAddresses.add(address);
            }
            ++i;
        }
    }

    private boolean isLocalAddress(Address address) throws UnknownHostException {
        Address thisAddress = this.node.address;
        boolean local = thisAddress.getInetSocketAddress().equals(address.getInetSocketAddress());
        this.logger.log(Level.FINEST, address + " is local? " + local);
        return local;
    }

    protected Collection<String> getMembers() {
        return TcpIpJoiner.getConfigurationMembers(this.config);
    }

    public static Collection<String> getConfigurationMembers(Config config) {
        TcpIpConfig tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
        List<String> configMembers = tcpIpConfig.getMembers();
        HashSet<String> possibleMembers = new HashSet<String>();
        for (String member : configMembers) {
            String[] members = member.split("[,; ]");
            Collections.addAll(possibleMembers, members);
        }
        return possibleMembers;
    }

    @Override
    public void searchForOtherClusters(SplitBrainHandler splitBrainHandler) {
        Collection<Address> colPossibleAddresses;
        try {
            colPossibleAddresses = this.getPossibleAddresses();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        colPossibleAddresses.remove(this.node.getThisAddress());
        for (Member member : this.node.getClusterImpl().getMembers()) {
            colPossibleAddresses.remove(((MemberImpl)member).getAddress());
        }
        if (colPossibleAddresses.isEmpty()) {
            return;
        }
        for (Address possibleAddress : colPossibleAddresses) {
            JoinInfo response;
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " is connecting to " + possibleAddress);
            this.node.connectionManager.getOrConnect(possibleAddress, true);
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                return;
            }
            Connection conn = this.node.connectionManager.getConnection(possibleAddress);
            if (conn == null || (response = this.node.clusterManager.checkJoin(conn)) == null || !this.shouldMerge(response)) continue;
            this.logger.log(Level.WARNING, this.node.address + " is merging [tcp/ip] to " + possibleAddress);
            this.targetAddress = possibleAddress;
            this.node.clusterManager.sendClusterMergeToOthers(this.targetAddress);
            splitBrainHandler.restart();
            return;
        }
    }

    public static class MasterAnswer
    extends AbstractRemotelyProcessable {
        Address respondingAddress = null;
        boolean approved = false;

        public MasterAnswer(Address respondingAddress, boolean approved) {
            this.respondingAddress = respondingAddress;
            this.approved = approved;
        }

        public MasterAnswer() {
        }

        @Override
        public void process() {
            TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)this.getNode().getJoiner();
            if (!this.approved) {
                tcpIpJoiner.approved = false;
            }
            tcpIpJoiner.responseCounter.decrementAndGet();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            out.writeBoolean(this.approved);
            this.respondingAddress.writeData(out);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.approved = in.readBoolean();
            this.respondingAddress = new Address();
            this.respondingAddress.readData(in);
        }
    }

    public static class MasterQuestion
    extends AbstractRemotelyProcessable {
        @Override
        public void process() {
            Joiner joiner = this.node.getJoiner();
            Connection conn = this.getConnection();
            Address endpoint = conn.getEndPoint();
            boolean shouldApprove = false;
            if (joiner instanceof TcpIpJoiner) {
                TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)joiner;
                Address masterAddress = this.node.getMasterAddress();
                shouldApprove = !tcpIpJoiner.askingForApproval && !this.node.isMaster() && (masterAddress == null || masterAddress.equals(endpoint));
            }
            this.node.clusterManager.sendProcessableTo((RemotelyProcessable)new MasterAnswer(this.node.getThisAddress(), shouldApprove), conn);
        }
    }
}

