/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.document;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.artofsolving.jodconverter.document.SimpleDocumentFormatRegistry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonDocumentFormatRegistry
extends SimpleDocumentFormatRegistry {
    public JsonDocumentFormatRegistry(InputStream input) throws JSONException, IOException {
        this.readJsonArray(IOUtils.toString((InputStream)input));
    }

    public JsonDocumentFormatRegistry(String source) throws JSONException {
        this.readJsonArray(source);
    }

    private void readJsonArray(String source) throws JSONException {
        JSONArray array = new JSONArray(source);
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jsonFormat = array.getJSONObject(i);
            DocumentFormat format = new DocumentFormat();
            format.setName(jsonFormat.getString("name"));
            format.setExtension(jsonFormat.getString("extension"));
            format.setMediaType(jsonFormat.getString("mediaType"));
            if (jsonFormat.has("inputFamily")) {
                format.setInputFamily(DocumentFamily.valueOf(jsonFormat.getString("inputFamily")));
            }
            if (jsonFormat.has("loadProperties")) {
                format.setLoadProperties(this.toJavaMap(jsonFormat.getJSONObject("loadProperties")));
            }
            if (jsonFormat.has("storePropertiesByFamily")) {
                JSONObject jsonStorePropertiesByFamily = jsonFormat.getJSONObject("storePropertiesByFamily");
                for (String key : JSONObject.getNames((JSONObject)jsonStorePropertiesByFamily)) {
                    Map<String, ?> storeProperties = this.toJavaMap(jsonStorePropertiesByFamily.getJSONObject(key));
                    format.setStoreProperties(DocumentFamily.valueOf(key), storeProperties);
                }
            }
            this.addFormat(format);
        }
    }

    private Map<String, ?> toJavaMap(JSONObject jsonMap) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : JSONObject.getNames((JSONObject)jsonMap)) {
            Object value = jsonMap.get(key);
            if (value instanceof JSONObject) {
                map.put(key, this.toJavaMap((JSONObject)value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }
}

