/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jfif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.jfif.JfifDirectory;

public class JfifDescriptor
extends TagDescriptor<JfifDirectory> {
    public JfifDescriptor(@NotNull JfifDirectory jfifDirectory) {
        super(jfifDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 8: {
                return this.getImageResXDescription();
            }
            case 10: {
                return this.getImageResYDescription();
            }
            case 5: {
                return this.getImageVersionDescription();
            }
            case 7: {
                return this.getImageResUnitsDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getImageVersionDescription() {
        Integer n = ((JfifDirectory)this._directory).getInteger(5);
        if (n == null) {
            return null;
        }
        return String.format("%d.%d", (n & 0xFF00) >> 8, n & 0xFF);
    }

    @Nullable
    public String getImageResYDescription() {
        Integer n = ((JfifDirectory)this._directory).getInteger(10);
        if (n == null) {
            return null;
        }
        return String.format("%d dot%s", n, n == 1 ? "" : "s");
    }

    @Nullable
    public String getImageResXDescription() {
        Integer n = ((JfifDirectory)this._directory).getInteger(8);
        if (n == null) {
            return null;
        }
        return String.format("%d dot%s", n, n == 1 ? "" : "s");
    }

    @Nullable
    public String getImageResUnitsDescription() {
        Integer n = ((JfifDirectory)this._directory).getInteger(7);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "none";
            }
            case 1: {
                return "inch";
            }
            case 2: {
                return "centimetre";
            }
        }
        return "unit";
    }
}

