/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.FontMetric;
import org.apache.fontbox.cff.AFMFormatter;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.Type1FontFormatter;
import org.apache.fontbox.cff.charset.CFFCharset;
import org.apache.fontbox.cff.encoding.CFFEncoding;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDType1CFont
extends PDSimpleFont {
    private CFFFont cffFont = null;
    private Map<Integer, String> codeToName = new HashMap<Integer, String>();
    private Map<Integer, String> codeToCharacter = new HashMap<Integer, String>();
    private Map<String, Integer> characterToCode = new HashMap<String, Integer>();
    private FontMetric fontMetric = null;
    private Font awtFont = null;
    private Map<String, Float> glyphWidths = new HashMap<String, Float>();
    private Map<String, Float> glyphHeights = new HashMap<String, Float>();
    private Float avgWidth = null;
    private PDRectangle fontBBox = null;
    private static final Log log = LogFactory.getLog(PDType1CFont.class);
    private static final byte[] SPACE_BYTES = new byte[]{32};
    private COSDictionary fontDict = null;

    public PDType1CFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.fontDict = fontDictionary;
        this.load();
    }

    @Override
    public String encode(byte[] bytes, int offset, int length) throws IOException {
        String character = this.getCharacter(bytes, offset, length);
        if (character == null) {
            log.debug((Object)("No character for code " + (bytes[offset] & 0xFF) + " in " + this.cffFont.getName()));
            return null;
        }
        return character;
    }

    @Override
    public int encodeToCID(byte[] bytes, int offset, int length) {
        if (length > 2) {
            return -1;
        }
        int code = bytes[offset] & 0xFF;
        if (length == 2) {
            code = code * 256 + bytes[offset + 1] & 0xFF;
        }
        return code;
    }

    private String getCharacter(byte[] bytes, int offset, int length) {
        int code = this.encodeToCID(bytes, offset, length);
        if (code == -1) {
            return null;
        }
        return this.codeToCharacter.get(code);
    }

    @Override
    public float getFontWidth(byte[] bytes, int offset, int length) throws IOException {
        String name = this.getName(bytes, offset, length);
        if (name == null && !Arrays.equals(SPACE_BYTES, bytes)) {
            log.debug((Object)("No name for code " + (bytes[offset] & 0xFF) + " in " + this.cffFont.getName()));
            return 0.0f;
        }
        Float width = this.glyphWidths.get(name);
        if (width == null) {
            width = Float.valueOf(this.getFontMetric().getCharacterWidth(name));
            this.glyphWidths.put(name, width);
        }
        return width.floatValue();
    }

    @Override
    public float getFontHeight(byte[] bytes, int offset, int length) throws IOException {
        String name = this.getName(bytes, offset, length);
        if (name == null) {
            log.debug((Object)("No name for code " + (bytes[offset] & 0xFF) + " in " + this.cffFont.getName()));
            return 0.0f;
        }
        Float height = this.glyphHeights.get(name);
        if (height == null) {
            height = Float.valueOf(this.getFontMetric().getCharacterHeight(name));
            this.glyphHeights.put(name, height);
        }
        return height.floatValue();
    }

    private String getName(byte[] bytes, int offset, int length) {
        if (length > 2) {
            return null;
        }
        int code = bytes[offset] & 0xFF;
        if (length == 2) {
            code = code * 256 + bytes[offset + 1] & 0xFF;
        }
        return this.codeToName.get(code);
    }

    @Override
    public float getStringWidth(String string) throws IOException {
        float width = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            String character = string.substring(i, i + 1);
            Integer code = this.getCode(character);
            if (code == null) {
                log.debug((Object)("No code for character " + character));
                return 0.0f;
            }
            width += this.getFontWidth(new byte[]{(byte)code.intValue()}, 0, 1);
        }
        return width;
    }

    private Integer getCode(String character) {
        return this.characterToCode.get(character);
    }

    @Override
    public float getAverageFontWidth() throws IOException {
        if (this.avgWidth == null) {
            this.avgWidth = Float.valueOf(this.getFontMetric().getAverageCharacterWidth());
        }
        return this.avgWidth.floatValue();
    }

    @Override
    public PDRectangle getFontBoundingBox() throws IOException {
        if (this.fontBBox == null) {
            this.fontBBox = new PDRectangle(this.getFontMetric().getFontBBox());
        }
        return this.fontBBox;
    }

    @Override
    public PDMatrix getFontMatrix() {
        if (this.fontMatrix == null) {
            List numbers = (List)this.cffFont.getProperty("FontMatrix");
            if (numbers != null && numbers.size() == 6) {
                COSArray array = new COSArray();
                for (Number number : numbers) {
                    array.add(new COSFloat(number.floatValue()));
                }
                this.fontMatrix = new PDMatrix(array);
            } else {
                super.getFontMatrix();
            }
        }
        return this.fontMatrix;
    }

    @Override
    public Font getawtFont() throws IOException {
        if (this.awtFont == null) {
            this.awtFont = PDType1CFont.prepareAwtFont(this.cffFont);
        }
        return this.awtFont;
    }

    private FontMetric getFontMetric() {
        if (this.fontMetric == null) {
            try {
                this.fontMetric = this.prepareFontMetric(this.cffFont);
            }
            catch (IOException exception) {
                log.error((Object)"An error occured while extracting the font metrics!", (Throwable)exception);
            }
        }
        return this.fontMetric;
    }

    private void load() throws IOException {
        Map nameToCharacter;
        byte[] cffBytes = this.loadBytes();
        CFFParser cffParser = new CFFParser();
        List<CFFFont> fonts = cffParser.parse(cffBytes);
        String baseFontName = this.getBaseFont();
        if (fonts.size() > 1 && baseFontName != null) {
            for (CFFFont font : fonts) {
                if (!baseFontName.equals(font.getName())) continue;
                this.cffFont = font;
                break;
            }
        }
        if (this.cffFont == null) {
            this.cffFont = fonts.get(0);
        }
        CFFEncoding encoding = this.cffFont.getEncoding();
        PDFEncoding pdfEncoding = new PDFEncoding(encoding);
        CFFCharset charset = this.cffFont.getCharset();
        PDFCharset pdfCharset = new PDFCharset(charset);
        Map<String, byte[]> charStringsDict = this.cffFont.getCharStringsDict();
        LinkedHashMap<String, byte[]> pdfCharStringsDict = new LinkedHashMap<String, byte[]>();
        pdfCharStringsDict.put(".notdef", charStringsDict.get(".notdef"));
        LinkedHashMap<Integer, String> codeToNameMap = new LinkedHashMap<Integer, String>();
        Collection<CFFFont.Mapping> mappings = this.cffFont.getMappings();
        for (CFFFont.Mapping mapping : mappings) {
            Integer code = mapping.getCode();
            String name = mapping.getName();
            codeToNameMap.put(code, name);
        }
        HashSet knownNames = new HashSet(codeToNameMap.values());
        Map<Integer, String> codeToNameOverride = this.loadOverride();
        for (Map.Entry<Integer, String> entry : codeToNameOverride.entrySet()) {
            Integer code = entry.getKey();
            String name = entry.getValue();
            if (!knownNames.contains(name)) continue;
            codeToNameMap.put(code, name);
        }
        try {
            Field nameToCharacterField = Encoding.class.getDeclaredField("NAME_TO_CHARACTER");
            nameToCharacterField.setAccessible(true);
            nameToCharacter = (Map)nameToCharacterField.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : codeToNameMap.entrySet()) {
            Integer code = (Integer)entry.getKey();
            String name = (String)entry.getValue();
            String uniName = "uni";
            String character = (String)nameToCharacter.get(name);
            if (character != null) {
                for (int j = 0; j < character.length(); ++j) {
                    uniName = uniName + PDType1CFont.hexString(character.charAt(j), 4);
                }
            } else {
                uniName = uniName + PDType1CFont.hexString(code, 4);
                character = String.valueOf((char)code.intValue());
            }
            pdfEncoding.register(code, code);
            pdfCharset.register(code, uniName);
            this.codeToName.put(code, uniName);
            this.codeToCharacter.put(code, character);
            this.characterToCode.put(character, code);
            pdfCharStringsDict.put(uniName, charStringsDict.get(name));
        }
        this.cffFont.setEncoding(pdfEncoding);
        this.cffFont.setCharset(pdfCharset);
        charStringsDict.clear();
        charStringsDict.putAll(pdfCharStringsDict);
        Number defaultWidthX = (Number)this.cffFont.getProperty("defaultWidthX");
        this.glyphWidths.put(null, Float.valueOf(defaultWidthX.floatValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadBytes() throws IOException {
        PDStream ff3Stream;
        PDFontDescriptor fd = this.getFontDescriptor();
        if (fd != null && fd instanceof PDFontDescriptorDictionary && (ff3Stream = ((PDFontDescriptorDictionary)fd).getFontFile3()) != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            InputStream is = ff3Stream.createInputStream();
            try {
                int count;
                byte[] buf = new byte[512];
                while ((count = is.read(buf)) >= 0) {
                    os.write(buf, 0, count);
                }
            }
            finally {
                is.close();
            }
            return os.toByteArray();
        }
        throw new IOException();
    }

    private Map<Integer, String> loadOverride() throws IOException {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        COSBase encoding = this.fontDict.getDictionaryObject(COSName.ENCODING);
        if (encoding instanceof COSName) {
            COSName name = (COSName)encoding;
            result.putAll(this.loadEncoding(name));
        } else if (encoding instanceof COSDictionary) {
            COSArray differences;
            COSDictionary encodingDic = (COSDictionary)encoding;
            COSName baseName = (COSName)encodingDic.getDictionaryObject(COSName.BASE_ENCODING);
            if (baseName != null) {
                result.putAll(this.loadEncoding(baseName));
            }
            if ((differences = (COSArray)encodingDic.getDictionaryObject(COSName.DIFFERENCES)) != null) {
                result.putAll(this.loadDifferences(differences));
            }
        }
        return result;
    }

    private Map<Integer, String> loadEncoding(COSName name) throws IOException {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        Encoding encoding = EncodingManager.INSTANCE.getEncoding(name);
        for (Map.Entry<Integer, String> entry : encoding.getCodeToNameMap().entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Map<Integer, String> loadDifferences(COSArray differences) {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        Integer code = null;
        for (int i = 0; i < differences.size(); ++i) {
            COSBase element = differences.get(i);
            if (element instanceof COSNumber) {
                COSNumber number = (COSNumber)element;
                code = number.intValue();
                continue;
            }
            if (!(element instanceof COSName)) continue;
            COSName name = (COSName)element;
            result.put(code, name.getName());
            code = code + 1;
        }
        return result;
    }

    private static String hexString(int code, int length) {
        String string = Integer.toHexString(code);
        while (string.length() < length) {
            string = "0" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontMetric prepareFontMetric(CFFFont font) throws IOException {
        byte[] afmBytes = AFMFormatter.format(font);
        ByteArrayInputStream is = new ByteArrayInputStream(afmBytes);
        try {
            AFMParser afmParser = new AFMParser(is);
            afmParser.parse();
            FontMetric result = afmParser.getResult();
            BoundingBox bounds = result.getFontBBox();
            List<Integer> numbers = Arrays.asList((int)bounds.getLowerLeftX(), (int)bounds.getLowerLeftY(), (int)bounds.getUpperRightX(), (int)bounds.getUpperRightY());
            font.addValueToTopDict("FontBBox", numbers);
            FontMetric fontMetric = result;
            return fontMetric;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static Font prepareAwtFont(CFFFont font) throws IOException {
        byte[] type1Bytes = Type1FontFormatter.format(font);
        ByteArrayInputStream is = new ByteArrayInputStream(type1Bytes);
        try {
            Font font2 = Font.createFont(1, is);
            return font2;
        }
        catch (FontFormatException ffe) {
            throw new WrappedIOException(ffe);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static class PDFCharset
    extends CFFCharset {
        private PDFCharset(CFFCharset parent) {
            Iterator<CFFCharset.Entry> parentEntries = parent.getEntries().iterator();
            while (parentEntries.hasNext()) {
                this.addEntry(parentEntries.next());
            }
        }

        public boolean isFontSpecific() {
            return true;
        }
    }

    private static class PDFEncoding
    extends CFFEncoding {
        private PDFEncoding(CFFEncoding parent) {
            Iterator<CFFEncoding.Entry> parentEntries = parent.getEntries().iterator();
            while (parentEntries.hasNext()) {
                this.addEntry(parentEntries.next());
            }
        }

        public boolean isFontSpecific() {
            return true;
        }
    }
}

