/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressiveDownloadInformationBox
extends AbstractFullBox {
    List<Entry> entries = Collections.emptyList();

    public ProgressiveDownloadInformationBox() {
        super(IsoFile.fourCCtoBytes("pdin"));
    }

    @Override
    protected long getContentSize() {
        return this.entries.size() * 8;
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        for (Entry entry : this.entries) {
            os.writeUInt32(entry.getRate());
            os.writeUInt32(entry.getInitialDelay());
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        size -= 4L;
        this.entries = new LinkedList<Entry>();
        while (size >= 8L) {
            Entry entry = new Entry(in.readUInt32(), in.readUInt32());
            this.entries.add(entry);
            size -= 8L;
        }
    }

    public String toString() {
        return "ProgressiveDownloadInfoBox{entries=" + this.entries + '}';
    }

    public static class Entry {
        long rate;
        long initialDelay;

        public Entry(long rate, long initialDelay) {
            this.rate = rate;
            this.initialDelay = initialDelay;
        }

        public long getRate() {
            return this.rate;
        }

        public void setRate(long rate) {
            this.rate = rate;
        }

        public long getInitialDelay() {
            return this.initialDelay;
        }

        public void setInitialDelay(long initialDelay) {
            this.initialDelay = initialDelay;
        }

        public String toString() {
            return "Entry{rate=" + this.rate + ", initialDelay=" + this.initialDelay + '}';
        }
    }
}

