/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONValue;
import org.json.helpers.StringAllocator;
import org.json.helpers.UnsynchronizedByteArrayOutputStream;

public final class JSONInputStream
extends InputStream {
    private static final int BUFSIZE = 8192;
    protected final String charset;
    private final Bufferer bufferer;
    protected int pos;
    protected int count;
    protected boolean finished = false;
    protected boolean first = true;
    protected final UnsynchronizedByteArrayOutputStream out;
    protected InputStream nested;

    public JSONInputStream(JSONValue jsonValue, String charset) {
        this.charset = charset;
        this.out = new UnsynchronizedByteArrayOutputStream(8192);
        if (jsonValue.isArray()) {
            this.bufferer = new ArrayBufferer(jsonValue.toArray().iterator());
            this.out.write(91);
        } else {
            this.bufferer = new ObjectBufferer(jsonValue.toObject().entrySet().iterator());
            this.out.write(123);
        }
        this.count = 1;
        this.pos = 0;
    }

    private boolean hasBytes() {
        return this.pos < this.count || this.nested != null;
    }

    private boolean writeMoreBytes() throws IOException {
        return this.bufferer.writeMoreBytes();
    }

    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (!this.hasBytes() && !this.writeMoreBytes()) {
            return this.out.getBuf()[this.pos++];
        }
        if (this.pos < this.count) {
            return this.out.getBuf()[this.pos++];
        }
        int read = this.nested.read();
        if (read >= 0) {
            return read;
        }
        this.nested = null;
        return this.read();
    }

    private abstract class AbstractBufferer
    implements Bufferer {
        protected AbstractBufferer() {
        }

        public boolean writeMoreBytes() throws IOException {
            JSONInputStream.this.out.reset();
            if (!this.hasNext()) {
                JSONInputStream.this.out.write(this.getClosing());
                JSONInputStream.this.count = 1;
                JSONInputStream.this.pos = 0;
                JSONInputStream.this.finished = true;
                JSONInputStream.this.nested = null;
                return false;
            }
            if (JSONInputStream.this.first) {
                JSONInputStream.this.first = false;
            } else {
                JSONInputStream.this.out.write(44);
            }
            this.writeValue(this.next());
            JSONInputStream.this.pos = 0;
            JSONInputStream.this.count = JSONInputStream.this.out.getCount();
            return true;
        }

        private void writeValue(Object value) throws IOException {
            if (value instanceof JSONValue) {
                JSONInputStream.this.nested = new JSONInputStream((JSONValue)value, JSONInputStream.this.charset);
            } else if (value instanceof String) {
                JSONInputStream.this.out.write(34);
                JSONInputStream.this.out.write(this.toAscii(value.toString()).getBytes(JSONInputStream.this.charset));
                JSONInputStream.this.out.write(34);
            } else {
                JSONInputStream.this.out.write((value == null ? "null" : value.toString()).getBytes(JSONInputStream.this.charset));
            }
        }

        private String toAscii(String str) {
            if (str == null) {
                return str;
            }
            int length = str.length();
            if (length == 0 || this.isAscii(str)) {
                return str;
            }
            StringAllocator sa = new StringAllocator(length * 3 / 2 + 1);
            int i = 0;
            while (i < length) {
                char c = str.charAt(i);
                if (c > '\u007f') {
                    this.appendAsJsonUnicode(c, sa);
                } else {
                    sa.append(c);
                }
                ++i;
            }
            return sa.toString();
        }

        private void appendAsJsonUnicode(int ch, StringAllocator sa) {
            sa.append("\\u");
            String hex = Integer.toString(ch, 16);
            int i = hex.length();
            while (i < 4) {
                sa.append('0');
                ++i;
            }
            sa.append(hex);
        }

        private boolean isAscii(String s) {
            if (s == null) {
                return true;
            }
            int length = s.length();
            if (length == 0) {
                return true;
            }
            boolean isAscci = true;
            int i = 0;
            while (i < length && isAscci) {
                isAscci = s.charAt(i) < '\u0080';
                ++i;
            }
            return isAscci;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ArrayBufferer
    extends AbstractBufferer {
        private final Iterator<Object> arrIterator;

        ArrayBufferer(Iterator<Object> arrIterator) {
            this.arrIterator = arrIterator;
        }

        @Override
        public char getClosing() {
            return ']';
        }

        @Override
        public boolean hasNext() {
            return this.arrIterator.hasNext();
        }

        @Override
        public Object next() {
            return this.arrIterator.next();
        }
    }

    private static interface Bufferer {
        public char getClosing();

        public boolean hasNext();

        public Object next() throws IOException;

        public boolean writeMoreBytes() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ObjectBufferer
    extends AbstractBufferer {
        private final Iterator<Map.Entry<String, Object>> objIterator;

        ObjectBufferer(Iterator<Map.Entry<String, Object>> objIterator) {
            this.objIterator = objIterator;
        }

        @Override
        public char getClosing() {
            return '}';
        }

        @Override
        public boolean hasNext() {
            return this.objIterator.hasNext();
        }

        @Override
        public Object next() throws IOException {
            Map.Entry<String, Object> entry = this.objIterator.next();
            JSONInputStream.this.out.write(34);
            JSONInputStream.this.out.write(entry.getKey().getBytes(JSONInputStream.this.charset));
            JSONInputStream.this.out.write(34);
            JSONInputStream.this.out.write(58);
            return entry.getValue();
        }
    }
}

