/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.text;

import java.util.HashMap;
import java.util.Map;
import org.javasimon.console.text.NoneStringifier;
import org.javasimon.console.text.Stringifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeStringifier
implements Stringifier<Object> {
    private final Map<StringifierKey, Stringifier> stringifiers = new HashMap<StringifierKey, Stringifier>();
    private Stringifier nullStringifier;
    private Stringifier defaultStringifier;

    public final <T> void add(Class<? extends T> type, Stringifier<T> stringifier) {
        this.add(type, null, stringifier);
    }

    public final <T> void add(Class<? extends T> type, String name, Stringifier<T> stringifier) {
        this.stringifiers.put(new StringifierKey(type, name), stringifier);
    }

    public final <T> Stringifier<T> getForType(Class<? extends T> type) {
        return this.getForType(type, null);
    }

    private <T> Stringifier<T> get(Class<? extends T> type, String subType) {
        Stringifier stringifier = null;
        if (subType != null) {
            stringifier = this.stringifiers.get(new StringifierKey(type, subType));
        }
        if (stringifier == null) {
            stringifier = this.stringifiers.get(new StringifierKey(type, null));
        }
        return stringifier;
    }

    public final <T> Stringifier<T> getForType(Class<? extends T> type, String subType) {
        return NoneStringifier.checkInstance(this.get(type, subType));
    }

    private <T> Stringifier<T> getForInstance(T object, String subType) {
        Stringifier stringifier;
        if (object == null) {
            stringifier = this.nullStringifier;
        } else {
            stringifier = this.get(object.getClass(), subType);
            if (stringifier == null) {
                stringifier = this.defaultStringifier;
            }
        }
        return NoneStringifier.checkInstance(stringifier);
    }

    @Override
    public String toString(Object object) {
        return this.getForInstance(object, null).toString(object);
    }

    public String toString(Object object, String subType) {
        return this.getForInstance(object, subType).toString(object);
    }

    public Stringifier getDefaultStringifier() {
        return this.defaultStringifier;
    }

    public void setDefaultStringifier(Stringifier defaultStringifier) {
        this.defaultStringifier = defaultStringifier;
    }

    public Stringifier getNullStringifier() {
        return this.nullStringifier;
    }

    public void setNullStringifier(Stringifier nullStringifier) {
        this.nullStringifier = nullStringifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringifierKey {
        private final Class<?> type;
        private final String subType;

        public StringifierKey(Class<?> type, String subType) {
            this.type = type;
            this.subType = subType;
        }

        private boolean equalsTo(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        private int hashCode(Object o) {
            return o == null ? 0 : o.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringifierKey other = (StringifierKey)obj;
            return this.equalsTo(this.type, other.type) && this.equalsTo(this.subType, other.subType);
        }

        public int hashCode() {
            return 3 + 5 * this.hashCode(this.type) + 7 * this.hashCode(this.subType);
        }

        public String toString() {
            return "StringifierKey[" + this.type.getName() + "," + this.subType + "]";
        }
    }
}

