/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.query.IndexStore;
import com.hazelcast.query.MultiResultSet;
import com.hazelcast.query.PredicateType;
import com.hazelcast.query.SingleResultSet;
import com.hazelcast.util.NavigableSet;
import com.hazelcast.util.concurrent.ConcurrentSkipListSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SortedIndexStore
implements IndexStore {
    private final ConcurrentMap<Long, ConcurrentMap<Long, Record>> mapRecords = new ConcurrentHashMap<Long, ConcurrentMap<Long, Record>>(100, 0.75f, 1);
    private final NavigableSet<Long> sortedSet = new ConcurrentSkipListSet<Long>();

    @Override
    public void getSubRecordsBetween(MultiResultSet results, Long from, Long to) {
        SortedSet<Long> values = this.sortedSet.subSet(from, to);
        for (Long value : values) {
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(value, records.values());
        }
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(to);
        if (records != null) {
            results.addResultSet(to, records.values());
        }
    }

    @Override
    public void getSubRecords(MultiResultSet results, PredicateType predicateType, Long searchedValue) {
        NavigableSet<Long> values = null;
        boolean notEqual = false;
        switch (predicateType) {
            case LESSER: {
                values = this.sortedSet.headSet(searchedValue, false);
                break;
            }
            case LESSER_EQUAL: {
                values = this.sortedSet.headSet(searchedValue, true);
                break;
            }
            case GREATER: {
                values = this.sortedSet.tailSet(searchedValue, false);
                break;
            }
            case GREATER_EQUAL: {
                values = this.sortedSet.tailSet(searchedValue, true);
                break;
            }
            case NOT_EQUAL: {
                values = this.sortedSet;
                notEqual = true;
            }
        }
        if (values != null) {
            for (Long value : values) {
                ConcurrentMap records;
                if (notEqual && searchedValue.longValue() == value.longValue() || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
                results.addResultSet(value, records.values());
            }
        }
    }

    @Override
    public void newRecordIndex(Long newValue, Record record) {
        long recordId = record.getId();
        ConcurrentHashMap<Long, Record> records = (ConcurrentHashMap<Long, Record>)this.mapRecords.get(newValue);
        if (records == null) {
            records = new ConcurrentHashMap<Long, Record>(1, 0.75f, 1);
            this.mapRecords.put(newValue, records);
            this.sortedSet.add(newValue);
        }
        records.put(recordId, record);
    }

    @Override
    public void removeRecordIndex(Long oldValue, Long recordId) {
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(oldValue);
        if (records != null) {
            records.remove(recordId);
            if (records.size() == 0) {
                this.mapRecords.remove(oldValue);
                this.sortedSet.remove(oldValue);
            }
        }
    }

    @Override
    public Set<MapEntry> getRecords(Long value) {
        return new SingleResultSet((ConcurrentMap)this.mapRecords.get(value));
    }

    @Override
    public void getRecords(MultiResultSet results, Set<Long> values) {
        for (Long value : values) {
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(value, records.values());
        }
    }

    @Override
    public ConcurrentMap<Long, ConcurrentMap<Long, Record>> getMapRecords() {
        return this.mapRecords;
    }

    public String toString() {
        return "SortedIndexStore{mapRecords=" + this.mapRecords.size() + '}';
    }
}

