/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DistributedSemaphore
implements DataSerializable {
    Map<Address, Integer> attachedPermits = new HashMap<Address, Integer>();
    int available;

    public DistributedSemaphore() {
    }

    public DistributedSemaphore(int initialPermits) {
        this.available = initialPermits;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.attachedPermits.clear();
        this.available = in.readInt();
        int entries = in.readInt();
        while (entries-- > 0) {
            Address address = new Address();
            address.readData(in);
            this.attachedPermits.put(address, in.readInt());
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.available);
        out.writeInt(this.attachedPermits.size());
        for (Map.Entry<Address, Integer> entry : this.attachedPermits.entrySet()) {
            entry.getKey().writeData(out);
            out.writeInt(entry.getValue());
        }
    }

    public void attachDetach(Integer permitsDelta, Address address) {
        if (permitsDelta != 0 && address != null) {
            int newValue = permitsDelta + this.getAttached(address);
            if (newValue != 0) {
                this.attachedPermits.put(address, newValue);
            } else {
                this.attachedPermits.remove(address);
            }
        }
    }

    public int drain() {
        int drained = this.available;
        this.available = 0;
        return drained;
    }

    public int getAttached() {
        int total = 0;
        for (Integer permits : this.attachedPermits.values()) {
            total += permits.intValue();
        }
        return total;
    }

    public int getAttached(Address address) {
        return this.attachedPermits.containsKey(address) ? this.attachedPermits.get(address) : 0;
    }

    public int getAvailable() {
        return this.available;
    }

    public void reduce(int permits) {
        this.available -= permits;
    }

    public void release(int permits, Address address) {
        this.available += permits;
        this.attachDetach(-permits, address);
    }

    public boolean tryAcquire(int permits, Address address) {
        if (this.available >= permits) {
            this.available -= permits;
            this.attachDetach(permits, address);
            return true;
        }
        return false;
    }

    public boolean onDisconnect(Address deadAddress) {
        Integer attached = this.attachedPermits.remove(deadAddress);
        if (attached != null && attached != 0) {
            this.available += attached.intValue();
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("Semaphore{available=%d, global attached=%d}", this.available, this.getAttached());
    }
}

