/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlArea
extends ClickableElement {
    private static final long serialVersionUID = 8933911141016200386L;
    public static final String TAG_NAME = "area";

    HtmlArea(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        HtmlPage enclosingPage = (HtmlPage)this.getPage();
        WebClient webClient = enclosingPage.getWebClient();
        String href = this.getHrefAttribute();
        if (href != null && href.length() > 0) {
            URL url;
            HtmlPage page = (HtmlPage)this.getPage();
            if (TextUtil.startsWithIgnoreCase(href, "javascript:")) {
                return page.executeJavaScriptIfPossible(href, "javascript url", this.getStartLineNumber()).getNewPage();
            }
            try {
                url = enclosingPage.getFullyQualifiedUrl(this.getHrefAttribute());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Not a valid url: " + this.getHrefAttribute());
            }
            WebRequestSettings settings = new WebRequestSettings(url);
            WebWindow webWindow = enclosingPage.getEnclosingWindow();
            return webClient.getPage(webWindow, enclosingPage.getResolvedTarget(this.getTargetAttribute()), settings);
        }
        return defaultPage;
    }

    public final String getShapeAttribute() {
        return this.getAttribute("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttribute("coords");
    }

    public final String getHrefAttribute() {
        return this.getAttribute("href");
    }

    public final String getNoHrefAttribute() {
        return this.getAttribute("nohref");
    }

    public final String getAltAttribute() {
        return this.getAttribute("alt");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    boolean containsPoint(int x, int y) {
        String shape = StringUtils.defaultIfEmpty((String)this.getShapeAttribute(), (String)"rect").toLowerCase();
        if ("default".equals(shape) && this.getCoordsAttribute() != null) {
            return true;
        }
        if ("rect".equals(shape) && this.getCoordsAttribute() != null) {
            double bottomY;
            double rightX;
            double topY;
            String[] coords = this.getCoordsAttribute().split(",");
            double leftX = Double.parseDouble(coords[0].trim());
            Rectangle2D.Double rectangle = new Rectangle2D.Double(leftX, topY = Double.parseDouble(coords[1].trim()), (rightX = Double.parseDouble(coords[2].trim())) - leftX + 1.0, (bottomY = Double.parseDouble(coords[3].trim())) - topY + 1.0);
            if (rectangle.contains(x, y)) {
                return true;
            }
        } else if ("circle".equals(shape) && this.getCoordsAttribute() != null) {
            int radius;
            String[] coords = this.getCoordsAttribute().split(",");
            double centerX = Double.parseDouble(coords[0].trim());
            double centerY = Double.parseDouble(coords[1].trim());
            String radiusString = coords[2].trim();
            try {
                radius = Integer.parseInt(radiusString);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("Circle radius of " + radiusString + " is not yet implemented.");
            }
            Ellipse2D.Double ellipse = new Ellipse2D.Double(centerX - (double)(radius / 2), centerY - (double)(radius / 2), radius, radius);
            if (ellipse.contains(x, y)) {
                return true;
            }
        } else if ("poly".equals(shape) && this.getCoordsAttribute() != null) {
            String[] coords = this.getCoordsAttribute().split(",");
            GeneralPath path = new GeneralPath();
            int i = 0;
            while (i + 1 < coords.length) {
                if (i == 0) {
                    path.moveTo(Float.parseFloat(coords[i]), Float.parseFloat(coords[i + 1]));
                } else {
                    path.lineTo(Float.parseFloat(coords[i]), Float.parseFloat(coords[i + 1]));
                }
                i += 2;
            }
            path.closePath();
            if (path.contains(x, y)) {
                return true;
            }
        }
        return false;
    }
}

