/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalAtomicNumberStatsImpl;
import com.hazelcast.impl.monitor.LocalCountDownLatchStatsImpl;
import com.hazelcast.impl.monitor.LocalExecutorOperationStatsImpl;
import com.hazelcast.impl.monitor.LocalInstanceStatsSupport;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.LocalQueueStatsImpl;
import com.hazelcast.impl.monitor.LocalSemaphoreStatsImpl;
import com.hazelcast.impl.monitor.LocalTopicStatsImpl;
import com.hazelcast.impl.monitor.MemberHealthStatsImpl;
import com.hazelcast.monitor.LocalAtomicNumberStats;
import com.hazelcast.monitor.LocalCountDownLatchStats;
import com.hazelcast.monitor.LocalExecutorOperationStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.monitor.LocalSemaphoreStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemberStateImpl
implements MemberState {
    private static final long serialVersionUID = -1817978625085375340L;
    Address address = new Address();
    MemberHealthStatsImpl memberHealthStats = new MemberHealthStatsImpl();
    Map<String, Long> runtimeProps = new HashMap<String, Long>();
    Map<String, LocalMapStatsImpl> mapStats = new HashMap<String, LocalMapStatsImpl>();
    Map<String, LocalMapStatsImpl> multiMapStats = new HashMap<String, LocalMapStatsImpl>();
    Map<String, LocalQueueStatsImpl> queueStats = new HashMap<String, LocalQueueStatsImpl>();
    Map<String, LocalTopicStatsImpl> topicStats = new HashMap<String, LocalTopicStatsImpl>();
    Map<String, LocalAtomicNumberStatsImpl> atomicNumberStats = new HashMap<String, LocalAtomicNumberStatsImpl>();
    Map<String, LocalCountDownLatchStatsImpl> countDownLatchStats = new HashMap<String, LocalCountDownLatchStatsImpl>();
    Map<String, LocalSemaphoreStatsImpl> semaphoreStats = new HashMap<String, LocalSemaphoreStatsImpl>();
    List<Integer> lsPartitions = new ArrayList<Integer>(271);
    Map<String, LocalExecutorOperationStatsImpl> internalThroughputStats = new HashMap<String, LocalExecutorOperationStatsImpl>();
    Map<String, LocalExecutorOperationStatsImpl> throughputStats = new HashMap<String, LocalExecutorOperationStatsImpl>();

    @Override
    public void writeData(DataOutput out) throws IOException {
        this.address.writeData(out);
        this.memberHealthStats.writeData(out);
        out.writeInt(this.mapStats.size());
        for (Map.Entry<String, LocalMapStatsImpl> entry : this.mapStats.entrySet()) {
            out.writeUTF(entry.getKey());
            entry.getValue().writeData(out);
        }
        out.writeInt(this.multiMapStats.size());
        for (Map.Entry<String, LocalMapStatsImpl> entry : this.multiMapStats.entrySet()) {
            out.writeUTF(entry.getKey());
            entry.getValue().writeData(out);
        }
        out.writeInt(this.queueStats.size());
        for (Map.Entry<String, LocalInstanceStatsSupport> entry : this.queueStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalQueueStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.topicStats.size());
        for (Map.Entry<String, LocalInstanceStatsSupport> entry : this.topicStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalTopicStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.atomicNumberStats.size());
        for (Map.Entry<String, LocalInstanceStatsSupport> entry : this.atomicNumberStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalAtomicNumberStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.countDownLatchStats.size());
        for (Map.Entry<String, LocalInstanceStatsSupport> entry : this.countDownLatchStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalCountDownLatchStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.semaphoreStats.size());
        for (Map.Entry<String, LocalInstanceStatsSupport> entry : this.semaphoreStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalSemaphoreStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.runtimeProps.size());
        for (Map.Entry<String, Serializable> entry : this.runtimeProps.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeLong((Long)entry.getValue());
        }
        out.writeInt(this.internalThroughputStats.size());
        for (Map.Entry<String, Serializable> entry : this.internalThroughputStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalExecutorOperationStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.throughputStats.size());
        for (Map.Entry<String, Serializable> entry : this.throughputStats.entrySet()) {
            out.writeUTF(entry.getKey());
            ((LocalExecutorOperationStatsImpl)entry.getValue()).writeData(out);
        }
        out.writeInt(this.lsPartitions.size());
        for (Integer n : this.lsPartitions) {
            out.writeInt(n);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        DataSerializable impl;
        String name;
        this.address.readData(in);
        this.memberHealthStats.readData(in);
        int i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalMapStatsImpl();
            impl.readData(in);
            this.mapStats.put(name, (LocalMapStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalMapStatsImpl();
            impl.readData(in);
            this.multiMapStats.put(name, (LocalMapStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalQueueStatsImpl();
            impl.readData(in);
            this.queueStats.put(name, (LocalQueueStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalTopicStatsImpl();
            impl.readData(in);
            this.topicStats.put(name, (LocalTopicStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalAtomicNumberStatsImpl();
            impl.readData(in);
            this.atomicNumberStats.put(name, (LocalAtomicNumberStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalCountDownLatchStatsImpl();
            impl.readData(in);
            this.countDownLatchStats.put(name, (LocalCountDownLatchStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalSemaphoreStatsImpl();
            impl.readData(in);
            this.semaphoreStats.put(name, (LocalSemaphoreStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            this.runtimeProps.put(name, in.readLong());
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalExecutorOperationStatsImpl(name);
            impl.readData(in);
            this.internalThroughputStats.put(name, (LocalExecutorOperationStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            name = in.readUTF();
            impl = new LocalExecutorOperationStatsImpl(name);
            impl.readData(in);
            this.throughputStats.put(name, (LocalExecutorOperationStatsImpl)impl);
            --i;
        }
        i = in.readInt();
        while (i > 0) {
            this.lsPartitions.add(in.readInt());
            --i;
        }
    }

    public void clearPartitions() {
        this.lsPartitions.clear();
    }

    public void addPartition(int partitionId) {
        this.lsPartitions.add(partitionId);
    }

    @Override
    public List<Integer> getPartitions() {
        return this.lsPartitions;
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.memberHealthStats != null ? this.memberHealthStats.hashCode() : 0);
        result = 31 * result + (this.mapStats != null ? this.mapStats.hashCode() : 0);
        result = 31 * result + (this.multiMapStats != null ? this.multiMapStats.hashCode() : 0);
        result = 31 * result + (this.queueStats != null ? this.queueStats.hashCode() : 0);
        result = 31 * result + (this.topicStats != null ? this.topicStats.hashCode() : 0);
        result = 31 * result + (this.atomicNumberStats != null ? this.atomicNumberStats.hashCode() : 0);
        result = 31 * result + (this.countDownLatchStats != null ? this.countDownLatchStats.hashCode() : 0);
        result = 31 * result + (this.semaphoreStats != null ? this.semaphoreStats.hashCode() : 0);
        result = 31 * result + (this.lsPartitions != null ? this.lsPartitions.hashCode() : 0);
        return result;
    }

    @Override
    public MemberHealthStatsImpl getMemberHealthStats() {
        return this.memberHealthStats;
    }

    public void setRuntimeProps(Map<String, Long> runtimeProps) {
        this.runtimeProps = runtimeProps;
    }

    @Override
    public Map<String, Long> getRuntimeProps() {
        return this.runtimeProps;
    }

    @Override
    public LocalAtomicNumberStats getLocalAtomicNumberStats(String atomicLongName) {
        return this.atomicNumberStats.get(atomicLongName);
    }

    @Override
    public LocalCountDownLatchStats getLocalCountDownLatchStats(String countDownLatchName) {
        return this.countDownLatchStats.get(countDownLatchName);
    }

    @Override
    public LocalMapStats getLocalMapStats(String mapName) {
        return this.mapStats.get(mapName);
    }

    @Override
    public LocalMapStats getLocalMultiMapStats(String mapName) {
        return this.multiMapStats.get(mapName);
    }

    @Override
    public LocalExecutorOperationStats getInternalExecutorStats(String name) {
        return this.internalThroughputStats.get(name);
    }

    @Override
    public LocalExecutorOperationStats getExternalExecutorStats(String name) {
        return this.throughputStats.get(name);
    }

    @Override
    public LocalQueueStats getLocalQueueStats(String queueName) {
        return this.queueStats.get(queueName);
    }

    @Override
    public LocalSemaphoreStats getLocalSemaphoreStats(String semaphoreName) {
        return this.semaphoreStats.get(semaphoreName);
    }

    @Override
    public LocalTopicStats getLocalTopicStats(String topicName) {
        return this.topicStats.get(topicName);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void putLocalAtomicNumberStats(String name, LocalAtomicNumberStatsImpl localAtomicLongStats) {
        this.atomicNumberStats.put(name, localAtomicLongStats);
    }

    public void putLocalCountDownLatchStats(String name, LocalCountDownLatchStatsImpl localCountDownLatchStats) {
        this.countDownLatchStats.put(name, localCountDownLatchStats);
    }

    public void putLocalMapStats(String name, LocalMapStatsImpl localMapStats) {
        this.mapStats.put(name, localMapStats);
    }

    public void putLocalMultiMapStats(String name, LocalMapStatsImpl localMultiMapStats) {
        this.multiMapStats.put(name, localMultiMapStats);
    }

    public void putLocalQueueStats(String name, LocalQueueStatsImpl localQueueStats) {
        this.queueStats.put(name, localQueueStats);
    }

    public void putLocalSemaphoreStats(String name, LocalSemaphoreStatsImpl localSemaphoreStats) {
        this.semaphoreStats.put(name, localSemaphoreStats);
    }

    public void putLocalTopicStats(String name, LocalTopicStatsImpl localTopicStats) {
        this.topicStats.put(name, localTopicStats);
    }

    public void putInternalThroughputStats(Map<String, LocalExecutorOperationStatsImpl> internalThroughputStats) {
        this.internalThroughputStats.putAll(internalThroughputStats);
    }

    public void putThroughputStats(Map<String, LocalExecutorOperationStatsImpl> throughputStats) {
        this.throughputStats.putAll(throughputStats);
    }

    public String toString() {
        return "MemberStateImpl [" + this.address + "] " + "\n{ " + "\n\t" + this.memberHealthStats + "\n\tmapStats=" + this.mapStats + "\n\tqueueStats=" + this.queueStats + "\n\tpartitions=" + this.lsPartitions + "\n}";
    }
}

