/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.impl.FactoryImpl;

public final class OutOfMemoryErrorDispatcher {
    private static final HazelcastInstance[] instances = new HazelcastInstance[50];
    private static int size = 0;
    private static OutOfMemoryHandler handler = new DefaultOutOfMemoryHandler();

    public static synchronized void setHandler(OutOfMemoryHandler outOfMemoryHandler) {
        handler = outOfMemoryHandler;
    }

    static synchronized boolean register(FactoryImpl factory) {
        if (size < instances.length - 1) {
            OutOfMemoryErrorDispatcher.instances[OutOfMemoryErrorDispatcher.size++] = factory;
            return true;
        }
        return false;
    }

    static synchronized boolean deregister(FactoryImpl factory) {
        int index = 0;
        while (index < instances.length) {
            HazelcastInstance hz = instances[index];
            if (hz == factory) {
                try {
                    int numMoved = size - index - 1;
                    if (numMoved > 0) {
                        System.arraycopy(instances, index + 1, instances, index, numMoved);
                    }
                    OutOfMemoryErrorDispatcher.instances[--OutOfMemoryErrorDispatcher.size] = null;
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++index;
        }
        return false;
    }

    static synchronized void clear() {
        int i = 0;
        while (i < instances.length) {
            OutOfMemoryErrorDispatcher.instances[i] = null;
            size = 0;
            ++i;
        }
    }

    public static synchronized void onOutOfMemory(OutOfMemoryError oom) {
        if (handler != null) {
            handler.onOutOfMemory(oom, instances);
        }
    }

    private OutOfMemoryErrorDispatcher() {
    }

    private static class DefaultOutOfMemoryHandler
    extends OutOfMemoryHandler {
        private DefaultOutOfMemoryHandler() {
        }

        @Override
        public void onOutOfMemory(OutOfMemoryError oom, HazelcastInstance[] hazelcastInstances) {
            HazelcastInstance[] hazelcastInstanceArray = hazelcastInstances;
            int n = hazelcastInstances.length;
            int n2 = 0;
            while (n2 < n) {
                HazelcastInstance instance = hazelcastInstanceArray[n2];
                if (instance != null) {
                    Helper.tryCloseConnections(instance);
                    Helper.tryStopThreads(instance);
                    Helper.tryShutdown(instance);
                }
                ++n2;
            }
        }
    }

    public static final class Helper {
        public static void tryCloseConnections(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            FactoryImpl factory = (FactoryImpl)hazelcastInstance;
            Helper.closeSockets(factory);
        }

        private static void closeSockets(FactoryImpl factory) {
            if (factory.node.connectionManager != null) {
                try {
                    factory.node.connectionManager.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public static void tryShutdown(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            FactoryImpl factory = (FactoryImpl)hazelcastInstance;
            Helper.closeSockets(factory);
            try {
                factory.node.doShutdown(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static void inactivate(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            FactoryImpl factory = (FactoryImpl)hazelcastInstance;
            factory.node.onOutOfMemory();
        }

        public static void tryStopThreads(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            FactoryImpl factory = (FactoryImpl)hazelcastInstance;
            try {
                factory.node.threadGroup.interrupt();
                factory.node.executorManager.stop();
                factory.node.clusterService.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

