/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.stringsearch;

import com.eaio.stringsearch.CharIntMap;
import com.eaio.stringsearch.StringSearch;

public class BoyerMooreHorspool
extends StringSearch {
    @Override
    public Object processBytes(byte[] pattern) {
        if (pattern.length == 1 || pattern.length == 2) {
            return null;
        }
        int[] skip = new int[256];
        int i = 0;
        while (i < skip.length) {
            skip[i] = pattern.length;
            ++i;
        }
        i = 0;
        while (i < pattern.length - 1) {
            skip[this.index((byte)pattern[i])] = pattern.length - i - 1;
            ++i;
        }
        return skip;
    }

    @Override
    public Object processChars(char[] pattern) {
        if (pattern.length == 1 || pattern.length == 2) {
            return null;
        }
        CharIntMap skip = this.createCharIntMap(pattern, pattern.length);
        int i = 0;
        while (i < pattern.length - 1) {
            skip.set(pattern[i], pattern.length - i - 1);
            ++i;
        }
        return skip;
    }

    @Override
    public int searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern, Object processed) {
        int lengthMinusOne;
        if (pattern.length == 1) {
            int nLimit = Math.min(text.length, textEnd);
            int n = textStart;
            while (n < nLimit) {
                if (text[n] == pattern[0]) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        if (pattern.length == 2) {
            int nLimit = Math.min(text.length, textEnd) - 1;
            int n = textStart;
            while (n < nLimit) {
                if (text[n] == pattern[0] && text[n + 1] == pattern[1]) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        int[] skip = (int[])processed;
        int k = lengthMinusOne = pattern.length - 1;
        while (k < textEnd) {
            int j = lengthMinusOne;
            int i = k;
            while (j >= 0 && text[i] == pattern[j] && i >= textStart) {
                --j;
                --i;
            }
            if (j == -1) {
                return ++i;
            }
            k += skip[this.index(text[k])];
        }
        return -1;
    }

    @Override
    public int searchChars(char[] text, int textStart, int textEnd, char[] pattern, Object processed) {
        int lengthMinusOne;
        if (pattern.length == 1) {
            int nLimit = Math.min(text.length, textEnd);
            int n = textStart;
            while (n < nLimit) {
                if (text[n] == pattern[0]) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        if (pattern.length == 2) {
            int nLimit = Math.min(text.length, textEnd) - 1;
            int n = textStart;
            while (n < nLimit) {
                if (text[n] == pattern[0] && text[n + 1] == pattern[1]) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        CharIntMap skip = (CharIntMap)processed;
        int k = lengthMinusOne = pattern.length - 1;
        while (k < textEnd) {
            int j = lengthMinusOne;
            int i = k;
            while (j >= 0 && text[i] == pattern[j] && i >= textStart) {
                --j;
                --i;
            }
            if (j == -1) {
                return ++i;
            }
            k += skip.get(text[k]);
        }
        return -1;
    }
}

