/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class AC {
    private int m;
    private int ell;
    private char[] x;
    private int[] kmpNext;

    private static void preKmp(char[] x, int[] kmpNext) {
        int m = x.length - 1;
        int i = 0;
        kmpNext[0] = -1;
        int j = -1;
        while (i < m) {
            while (j > -1 && x[i] != x[j]) {
                j = kmpNext[j];
            }
            if (x[++i] == x[++j]) {
                kmpNext[i] = kmpNext[j];
                continue;
            }
            kmpNext[i] = j;
        }
    }

    public static List<Integer> findAll(String pattern, String source) {
        char[] ptrn = pattern.toCharArray();
        char[] y = source.toCharArray();
        char[] x = new char[ptrn.length + 1];
        System.arraycopy(ptrn, 0, x, 0, ptrn.length);
        int m = ptrn.length;
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] kmpNext = new int[x.length];
        AC.preKmp(x, kmpNext);
        int ell = 1;
        while (x[ell - 1] == x[ell]) {
            ++ell;
        }
        if (ell == m) {
            ell = 0;
        }
        int i = ell;
        int k = 0;
        for (int j = 0; j <= n - m; j += i - kmpNext[i]) {
            while (i < m && x[i] == y[i + j]) {
                ++i;
            }
            if (i >= m) {
                while (k < ell && x[k] == y[j + k]) {
                    ++k;
                }
                if (k >= ell) {
                    result.add(j);
                }
            }
            if (i == ell) {
                k = Math.max(0, k - 1);
                continue;
            }
            if (kmpNext[i] <= ell) {
                k = Math.max(0, kmpNext[i]);
                i = ell;
                continue;
            }
            k = ell;
            i = kmpNext[i];
        }
        return result;
    }

    public static AC compile(String pattern) {
        char[] ptrn = pattern.toCharArray();
        char[] x = new char[ptrn.length + 1];
        System.arraycopy(ptrn, 0, x, 0, ptrn.length);
        int m = ptrn.length;
        int[] kmpNext = new int[x.length];
        AC.preKmp(x, kmpNext);
        int ell = 1;
        while (x[ell - 1] == x[ell]) {
            ++ell;
        }
        if (ell == m) {
            ell = 0;
        }
        AC ac = new AC();
        ac.m = m;
        ac.ell = ell;
        ac.x = x;
        ac.kmpNext = kmpNext;
        return ac;
    }

    public List<Integer> findAll(String source) {
        char[] y = source.toCharArray();
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = this.ell;
        int k = 0;
        for (int j = 0; j <= n - this.m; j += i - this.kmpNext[i]) {
            while (i < this.m && this.x[i] == y[i + j]) {
                ++i;
            }
            if (i >= this.m) {
                while (k < this.ell && this.x[k] == y[j + k]) {
                    ++k;
                }
                if (k >= this.ell) {
                    result.add(j);
                }
            }
            if (i == this.ell) {
                k = Math.max(0, k - 1);
                continue;
            }
            if (this.kmpNext[i] <= this.ell) {
                k = Math.max(0, this.kmpNext[i]);
                i = this.ell;
                continue;
            }
            k = this.ell;
            i = this.kmpNext[i];
        }
        return result;
    }
}

