/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import java.util.concurrent.CountDownLatch;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.utils.SimonUtils;

public final class MultithreadedSleeping
extends Thread {
    private static final int THREADS = 100;
    private static final int SLEEP = 1000;
    private static final String NAME = SimonUtils.generateNameForClass(null);
    private static final CountDownLatch latch = new CountDownLatch(100);

    private MultithreadedSleeping() {
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println("Going to run 1s sleep in 100 threads...");
        Split realTimeSplit = new Split();
        for (int i = 0; i < 100; ++i) {
            new MultithreadedSleeping().start();
        }
        latch.await();
        System.out.println("Simon: " + SimonManager.getStopwatch((String)NAME));
        System.out.println("Real time: " + realTimeSplit.stop());
    }

    public void run() {
        Stopwatch stopwatch = SimonManager.getStopwatch((String)NAME);
        Split split = stopwatch.start();
        try {
            MultithreadedSleeping.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        split.stop();
        latch.countDown();
    }
}

